<?php

$type = get_sub_field('slider_type');
$sliderTitle = get_sub_field('slider_title');

switch ($type) {
    case 'lodge':
        $sliders = get_sub_field('lodges');
        //$slidesToShow = 3;
        break;
    case 'news':
        $sliders = get_sub_field('latest_news');
        //$slidesToShow = 3;
        break;
    case 'events':
        $sliders = get_sub_field('events');
        //$slidesToShow = 3;
        break;
    case 'post':
        $sliders = get_sub_field('posts');
        //$slidesToShow = 3;
        break;
    case 'image':
        $sliders = get_sub_field('images');
        //$slidesToShow = 2;
        break;
    case 'custom':
        $sliders = get_sub_field('custom');
        //$slidesToShow = 2;
        break;
}

if($sliders) { ?>
    <section class="slider-section">
        
        <?php if($sliderTitle) { ?>
            <h3><?= $sliderTitle; ?></h3>
        <?php } ?>

        <div class="slider-content">
            <div class="slider" data-slidesToShow="<?= $slidesToShow; ?>">
                <?php
                foreach($sliders as $slide) {
                    $image = get_the_post_thumbnail_url( $slide['lodge']->ID, 'slider');
                    $locations = get_the_category($slide['lodge']->ID);
                    $location = $locations[0]->cat_name;
                    $location_id = get_cat_ID($location);
                    $location_link = get_category_link( $location_id );
                    $lodge = get_the_title( $slide['lodge']->ID );
                    $lodge_link = get_permalink($slide['lodge']->ID);
                    if($type == 'lodge') { ?>
                        <div>
                            <div class="lodge slider-card" style="background-image: url('<?= $image; ?>');">
                                <div class="lodge-location">
                                    <a href="<?= $location_link; ?>"><?= $location; ?></a>
                                </div>
                                <div class="lodge-title">
                                    <h4><a href="<?= $lodge_link; ?>"><?= $lodge; ?></a></h4>
                                </div>
                            </div>
                        </div>
                    <?php } elseif($type == 'news') { 
                        $image = get_the_post_thumbnail_url( $slide['news']->ID, 'slider');
                        ?>
                        <div>
                            <div class="article slider-card">
                                <div class="article-image">
                                    <a href="<?= get_permalink($slide['news']->ID); ?>"><img class="img-fluid" src="<?= $image; ?>" alt="Slider Image"></a>
                                </div>
                                <div class="article-date">
                                    <?= get_the_date( 'd F Y', $slide['news']->ID ); ?>
                                </div>
                                <div class="article-title">
                                    <a href="<?= get_permalink($slide['news']->ID); ?>"><?= get_the_title( $slide['news']->ID ); ?></a>
                                </div>
                                <div class="article-read-more">
                                    <a href="<?= get_permalink($slide['news']->ID); ?>">Read More</a>
                                </div>
                            </div>
                        </div>
                    <?php } elseif($type == 'events') { ?>
                        <div>
                            <div class="event slider-card">
                                <div class="event-image">
                                    <a href="<?= get_permalink($slide['news']->ID); ?>"><img class="img-fluid" src="<?= $image; ?>" alt="Slider Image"></a>
                                </div>
                                <div class="event-date">
                                    <?= get_the_date( 'd F Y', $slide['news']->ID ); ?>
                                </div>
                                <div class="event-title">
                                    <a href="<?= get_permalink($slide['news']->ID); ?>"><?= get_the_title( $slide['news']->ID ); ?></a>
                                </div>
                                <div class="event-read-more">
                                    <a href="<?= get_permalink($slide['news']->ID); ?>">Read More</a>
                                </div>
                            </div>
                        </div>
                    <?php } elseif($type == 'post') { ?>
                        <div>
                            <div class="post slider-card">
                                <div class="post-image">
                                    <a href="<?= get_permalink($slide['post']->ID); ?>"><img class="img-fluid" src="<?= $image; ?>" alt="Slider Image"></a>
                                </div>
                                <div class="post-date">
                                    <?= get_the_date( 'd F Y', $slide['post']->ID ); ?>
                                </div>
                                <div class="post-title">
                                    <a href="<?= get_permalink($slide['post']->ID); ?>"><?= get_the_title( $slide['post']->ID ); ?></a>
                                </div>
                                <div class="post-read-more">
                                    <a href="<?= get_permalink($slide['post']->ID); ?>">Read More</a>
                                </div>
                            </div>
                        </div>
                    <?php }  elseif($type == 'image') { 
                        $image = wp_get_attachment_url( $slide['image'] , 'slider' ); ?>
                        <div>
                            <div class="image">
                                <img src="<?= $image; ?>" alt="Slider Image">
                            </div>
                        </div>
                    <?php }  elseif($type == 'custom') { 
                        $image = $image = wp_get_attachment_url( $slide['image'], 'slider');
                        $heading = $slide['heading'];
                        $caption = $slide['caption'];
                        ?>
                        <div>
                            <div class="custom slider-card" style="background-image: url('<?= $image; ?>');">
                                <?php if($heading) { ?>
                                    <div class="custom-heading">
                                        <span><?= $heading; ?></span>
                                    </div>
                                <?php } ?>
                                
                                <?php if($caption) { ?>
                                    <div class="custom-caption">
                                        <h4><?= $caption; ?></h4>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    <?php }
                } ?>
            </div>
            <div class="progress">
                <div class="bar"></div>
            </div>
        </div>
    </section>
<?php }
?>