<?php

namespace Blue2\Scruffy\Controllers;

class SiteController
{
    public function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'mlv_enqueue_scripts']);
    }

    public function mlv_enqueue_scripts()
    {
        wp_enqueue_script( 'icontact-tracking-js', 'https://app.icontact.com/icp/static/form/javascripts/tracking.js');

        wp_enqueue_script( 'icontact-js', 'https://app.icontact.com/icp/static/form/javascripts/validation-captcha.js');

        wp_enqueue_script( 'slick-js', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array(), false, true);

        wp_enqueue_style('icontact-css','https://app.icontact.com/icp/static/human/css/signupBuilder/formGlobalStyles.css');

        wp_enqueue_style('slick-css','https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css');

        //wp_enqueue_style('slick-theme-css','https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css');
    }

    public static function auto_copyright($year = 'auto') {
        if(intval($year) == 'auto') { 
            $year = date('Y'); 
        }

        if(intval($year) == date('Y')) { 
            echo intval($year); 
        }

        if(intval($year) < date('Y')) { 
            echo intval($year) . ' - ' . date('Y'); 
        }

        if(intval($year) > date('Y')) { 
            echo date('Y'); 
        }
    }
}
