<?php
use Blue2\Scruffy\Controllers\SiteController;
?>

<footer class="site-footer">
    <div class="container-fluid">
        <div class="row">
            <div class="sign-up-form">
                <div class="col-md-4 mx-auto text-center">
                    <script type="text/javascript" src="//app.icontact.com/icp/core/mycontacts/signup/designer/form/automatic?id=266&cid=1137618&lid=6997"></script>
                </div>
            </div>
        </div>
    </div>
    
    <div class=" footer-bottom">
        <div class="container-xxl">
            <div class="row top-section">
                <div class="col-lg-3 col-10 footer-logo">
                    <?php $footerLogo = get_field('footer_logo', 'options');

                    if( !empty( $footerLogo ) ): ?>
                        <img src="<?php echo esc_url($footerLogo['url']); ?>" alt="<?php echo esc_attr($footerLogo['alt']); ?>" height="116" />
                    <?php else: ?>
                        <img src="" height="116" />
                    <?php endif; ?>
                </div>

                <div class="col-lg-2 col-5 quick-links">
                    <p class="menu-title">Quick Links</p>

                    <?php
                        wp_nav_menu( 
                            [
                                'theme_location' => 'quick_links',
                                'menu_class' => 'quick-links-menu'
                            ]
                        );
                    ?>
                </div>

                <div class="col-lg-2 col-5 help-links">
                    <p class="menu-title">Help Links</p>

                    <?php
                        wp_nav_menu( 
                            [
                                'theme_location' => 'help_links',
                                'menu_class' => 'help-links-menu'
                            ]
                        );
                    ?>
                </div>

                <div class="col-lg-3 col-10 footer-address">
                    <div class="address">
                        <?php 
                        $companyName = get_field('company_name', 'options'); 
                        $companyAddress = get_field('company_address', 'options');
                        $companyEmail = get_field('contact_email_address', 'options');
                        $companyPhone = get_field('contact_phone_number', 'options');
                        ?>

                        <p><?= $companyName; ?></p>
                        <div><?= $companyAddress; ?></div>
                        Tel: <?= $companyPhone; ?><br>
                        Email: <?= $companyEmail; ?><br>
                    </div>

                    <div class="socials">
                        <?php if (have_rows('social_media_channels', 'option')) { ?>
                            <ul class="footer-socials">
                                <?php
                                while (have_rows('social_media_channels', 'option')) {
                                    the_row(); ?>
                                    <li><a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a></li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <div class="row bottom-section">
                <div class="col-lg-5 col-10 legal">
                    <p class="copyright-text">Copyright &copy; <?php SiteController::auto_copyright('2021'); ?> <?= get_bloginfo( 'name' ); ?></p>
                    
                    <?php
                        wp_nav_menu( 
                            [
                                'theme_location' => 'legal_links',
                                'menu_class' => 'legal-links'
                            ]
                        );
                    ?>
                </div>

                <div class="col-lg-5 col-10 powered-by">
                    <P class="powered-by-text text-end">Website Powered By <a href="https:www.blue2.com">Blue2</a>
                </div>
            </div>
        </div>
    </div>
</footer>