<?php
$logo = get_sub_field('logo');
$description = get_sub_field('intro_text');
$link = get_sub_field('intro_button');
$buttonText = get_sub_field('intro_button_text');

if($buttonText == '') {
    $buttonText = 'Find Out More';
}
?>

<section class="intro_and_categories">
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-6 intro-section">
                <img src="<?= $logo; ?>" class="intro-logo mx-auto d-block" alt="Intro-Logo" height="130">

                <div class="intro-description"><?= $description; ?></div>

                <div class="d-grid gap-2 d-md-flex justify-content-md-end intro-button">
                    <a class="btn btn-primary" href="<?= $link; ?>"><span><?= $buttonText; ?></span></a>
                </div>
            </div> 
            <div class="col-md-4 intro-categories">
                <?php while (have_rows('intro_categories')) {
                    if (have_rows('intro_categories')) {
                        the_row();
                        $categoryImage = wp_get_attachment_url( get_sub_field('category_image') , 'card' );
                        $categoryTitle = get_sub_field('category_title');
                        $categoryLink = get_sub_field('category_link');
                        ?>
                        <a href="<?= $categoryLink; ?>">
                            <div class="category-card" style="background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('<?= $categoryImage; ?>');">
                                <h4><?= $categoryTitle; ?></h4>
                            </div>
                        </a>
                        <?php
                    }
                }?>
            </div>
        </div>
    </div>
</section>