<?php
//get our lodge information
$bedrooms = get_field('number_of_bedrooms');
$bathrooms = get_field('number_of_bathrooms');
$tel = get_field('telephone_number');
$locations = get_field('available_locations');
$price = get_field('lodge_price');
$hideEnquiry = get_field('hide_enquire_button');
$hidePlot = get_field('hide_available_plots_button');
$enquireLink = get_field('enquire_button_link');

if( $enquireLink ): 
    $link_url = $enquireLink['url'];
    $link_title = $enquireLink['title'];
    $link_target = $enquireLink['target'] ? $link['target'] : '_self';
else :
    $link_url = '';
    $link_title = 'Enquire';
    $link_target = '_self';
endif;

$plotLink = get_field('available_plots_link');

if( $plotLink ): 
    $plot_link_url = $plotLink['url'];
    $plot_link_title = $plotLink['title'];
    $plot_link_target = $plotLink['target'] ? $link['target'] : '_self';
else :
    $plot_link_url = '';
    $plot_link_title = 'Available Plots';
    $plot_link_target = '_self';
endif;
?>

<div <?php post_class("lodge-single"); ?>>
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-4">
                <h4>Overview</h4>

                <div class="overview-title">
                    Available Locations
                </div>

                <div class="overview-info">
                    <?= $locations; ?>
                </div>

                <div class="overview-title">
                    Bedrooms
                </div>

                <div class="overview-info">
                    <?= $bedrooms; ?>
                </div>

                <div class="overview-title">
                    Bathrooms
                </div>

                <div class="overview-info">
                    <?= $bathrooms; ?>
                </div>

                <?php if(!$hidePlot) { ?>
                    <div class="overview-availability">
                        <a class="btn btn-secondary" href="<?= $plot_link_url; ?>"><span><?= $plot_link_title; ?></span></a>
                    </div>
                <?php } ?>
                
                <?php if(!$hideEnquiry) { ?>
                    <div class="overview-enquiry">
                        <a class="btn btn-primary" href="<?= $link_url; ?>"><span><?= $link_title; ?></span></a>
                    </div>
                <?php } ?>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <div class="col-7">
                        <h2 class="fw-bold"><?= get_the_title();?></h2>
                    </div>
                    <div class="col-3">
                        <h2 class="fw-bold"><?= $price; ?></h2>
                    </div>
                </div>
                <div class="single-content-container">
                    <?php the_content(); ?>
                </div>

                <div class="request-brochure">
                    <a class="btn btn-secondary" href="<?php echo esc_url( '/request-a-brochure'  ); ?>"><span>Request a Brochure</span></a>
                </div>
            </div>
        </div>
    </div>

    <?php
    if(get_field('sections')) { ?>
        <div class="flexible-layout">
          <?php Blue2\Scruffy\Utils::flexibleLoop('sections'); ?>
        </div>
    <?php } ?>
</div>
