<?php
$panelType = get_sub_field('panel_type');
$image = wp_get_attachment_url( get_sub_field( "panel_image" ) , 'banner' );
$title = get_sub_field('panel_title');
$description = get_sub_field('panel_description');
$button = get_sub_field('panel_read_more_button');
$lodgeLogo = get_sub_field('lodge_logo');

switch ($panelType) {
    case 'image-left':
        $leftSize = 'col-md-6';
        $rightSize = 'col-md-4';
        $containerClass = 'image-left';
        break;
    case 'image-right':
        $leftSize = 'col-md-4';
        $rightSize = 'col-md-6';
        $containerClass = 'image-right';
        break;
}
?>
<section class="lodge-panel <?= $containerClass; ?>">
    <div class="container-fluid">
        <div class="row">
            <?php if($panelType == 'image-left') { ?>
                <div class="left-column cms <?= $leftSize; ?>" style="background-image:url('<?= $image; ?>');">
                </div>
            <?php } else { ?>
                <div class="left-column cms <?= $leftSize; ?>">
                    <img class="img-fluid lodge-logo" src="<?= $lodgeLogo;?>" alt="Lodge Logo" />
                    <p><?= $description; ?></p>
                    <a class="btn btn-primary" href="<?= $button['url']; ?>"><span><?= $button['title']; ?></span></a>
                </div>
            <?php } ?>

            <?php if($panelType == 'image-right') { ?>
                <div class="right-column cms <?= $rightSize; ?>" style="background-image:url('<?= $image; ?>');">
                </div>
            <?php } else { ?>
                <div class="right-column cms <?= $rightSize; ?>">
                    <img class="img-fluid lodge-logo" src="<?= $lodgeLogo;?>" alt="Lodge Logo" />
                    <p><?= $description; ?></p>
                    <a class="btn btn-primary" href="<?= $button['url']; ?>"><span><?= $button['title']; ?></span></a>
                </div>
            <?php } ?>
        </div>
    </div>
</section>