<?php

$args = array(  
    'post_type' => 'plot',
    'post_status' => 'publish',
    'posts_per_page' => -1
);

$plots = new WP_Query( $args ); ?>

<section class="sale-plots">
    <div class="container-xxl">
        <div class="row">
            <?php if( $plots->have_posts() ) {
                while ( $plots->have_posts() ) : $plots->the_post();
                    $saleStatus = get_field('plot_status');

                    if($saleStatus == 'sale') { ?>
                        <div class="col-md-3 mx-auto">
                            <?php
                            //this plot is still available
                            $saleDescription = get_field('lodge_description');
                            $locations = get_the_terms( get_the_ID(), 'locations' );
                            $location = $locations[0]->name;
                            $image = get_field('sale_image', get_the_ID());
                            $title = get_the_title();
                            $plotType = get_field('lodge_type', get_the_ID()); 
                            $price = get_field('lodge_price', get_the_ID());
                            $link = get_field('read_more_button', get_the_ID());
                            $linkTitle = $link['title'];
                            $linkURL = $link['url'];

                            if($linkURL == '') {
                                $linkURL = get_permalink();
                            }

                            if($linkTitle == '') {
                                $linkTitle = 'Learn More';
                            }
                            ?>
                            <div class="sale-image">
                                <img src="<?= $image; ?>" alt="For Sale Image" />
                            </div>
                            <span class="sale-title"><?= $title; ?> - <?= $location; ?></span>
                            <div class="sale-info">
                                <div class="sale-type">
                                    <h4 class="fw-bold"><?= $plotType; ?></h4>
                                    <h4 class="fw-bold"> <?= $price; ?></h4>
                                </div>
                                <div class="sale-description">
                                    <?= $saleDescription; ?>
                                </div>
                                <div class="more-button">
                                    <a class="btn btn-primary" href="<?php echo esc_url( $linkURL ); ?>"><span><?= $linkTitle; ?></span></a>
                                </div>
                            </div>
                        </div>
                    <?php }
                endwhile;

                wp_reset_postdata();
            } else { ?>
                <p>We currently have no plots for sale, please try again later</p>
            <?php } ?>
        </div>
    </div>
</section