<?php
//get our plot information
$type = get_field('lodge_type');
$bedrooms = get_field('number_of_bedrooms');
$bathrooms = get_field('number_of_bathrooms');
$locations = get_the_terms( get_the_ID(), 'locations' );
$location = $locations[0]->name;
$price = get_field('lodge_price');
?>

<div <?php post_class("lodge-single"); ?>>
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-4">
                <h4>Overview</h4>

                <div class="overview-title">
                    Lodge Type
                </div>

                <div class="overview-info">
                    <?= $type; ?>
                </div>

                <div class="overview-title">
                    Bedrooms
                </div>

                <div class="overview-info">
                    <?= $bedrooms; ?>
                </div>

                <div class="overview-title">
                    Bathrooms
                </div>

                <div class="overview-info">
                    <?= $bathrooms; ?>
                </div>

                <div class="overview-enquiry">
                    <a class="btn btn-primary" href="<?php echo esc_url( ''  ); ?>"><span>Enquire</span></a>
                </div>
                
            </div>
            <div class="col-md-6">
                <div class="row">
                    <div class="col-7">
                        <h2 class="fw-bold"><?= get_the_title();?>, <?= $location; ?></h2>
                    </div>
                    <div class="col-3">
                        <h2 class="fw-bold"><?= $price; ?></h2>
                    </div>
                </div>
                <div class="single-content-container">
                    <?php the_content(); ?>
                </div>

                <div class="request-brochure">
                    <a class="btn btn-secondary" href="<?php echo esc_url( '/request-a-brochure'  ); ?>"><span>Request a Brochure</span></a>
                </div>
            </div>
        </div>
    </div>

    <?php
    if(get_field('sections')) { ?>
        <div class="flexible-layout">
          <?php Blue2\Scruffy\Utils::flexibleLoop('sections'); ?>
        </div>
    <?php } ?>
</div>
