<?php
$base = $_SERVER['REQUEST_URI'];
$strings = explode("/", $base);
$strings = array_filter($strings);
$strings = array_values($strings);
$term = $strings[1];

$experiences = get_field($term . '-experiences', 'option');
?>

<section class="experience-plots">
    <div class="container-xxl experiences-container">
        <div class="row">
            <?php if($experiences) {
                foreach( $experiences as $experience ) {
                    if($experience['type_of_experience'] == 'internal') {
                        $post = $experience['choose_experience'];
                        $image = get_the_post_thumbnail_url(get_the_ID(),'card'); ?>

                        <div class="col-lg-3 col-md-6 col-sm-12 mx-auto experience-card d-flex align-items-end justify-content-center" style="background-image:url('<?= $image; ?>');">
                            <?php
                            $title = get_the_title();
                            $link = get_permalink();
                            ?>

                            <div class="d-grid gap-2 d-flex experience-button">
                                <a class="btn btn-primary" href="<?= $link; ?>"><span><?= $title; ?></span></a>
                            </div>
                        </div>
                    <?php } else {
                        $image = wp_get_attachment_image_url($experience['experience_image'],'card'); 
                        $title = $experience['experience_button_text'];
                        $link = $experience['experience_url'];
                        ?>

                        <div class="col-lg-3 col-md-6 col-sm-12 mx-auto experience-card d-flex align-items-end justify-content-center" style="background-image:url('<?= $image; ?>');">
                            <div class="d-grid gap-2 d-flex experience-button">
                                <a class="btn btn-primary" href="<?= $link; ?>" target="_blank"><span><?= $title; ?></span></a>
                            </div>
                        </div>
                    <?php }
                }
            } else { ?>
                <p>We currently have no experiences available, please try again later</p>
            <?php } ?>
        </div>
    </div>
</section>