<?php if(get_sub_field( "banner_image" )) {
    $bannerImage = wp_get_attachment_url( get_sub_field( "banner_image" ) , 'banner' );
} else {
    $bannerImage = '';
}

$bannerAlign =  get_sub_field( "content_position" );
$bannerText = get_sub_field('banner_text');

$removePaddingTop = get_sub_field('remove_padding_top');
$removePaddingBottom = get_sub_field('remove_padding_bottom');

$removeTop = '';
$removeBottom = '';

if($removePaddingTop) {
    $removeTop = 'removeTop';
}

if($removePaddingBottom) {
    $removeBottom = 'removeBottom';
}

if(get_sub_field("banner_height")) {
    $bannerHeight =  get_sub_field("banner_height");
} else {
    $bannerHeight = '790';
}
?>

<section class="banner-section <?= $removeTop; ?> <?= $removeBottom; ?>">
    <div class="jumbotron jumbotron-fluid banner" style="background-image: linear-gradient(rgba(0, 0, 0, 0.45), rgba(0, 0, 0, 0.45)), url('<?= $bannerImage; ?>'); height: <?= $bannerHeight; ?>px;">
        <div class="container banner-content <?= $bannerAlign; ?>">
            <h1 class="display-5 banner-header text-center"><?= $bannerText; ?></h1>

            <?php if (have_rows('call_to_action_buttons')) { ?>
                <p class="lead">
                    <ul class="cta-btn-row">
                        <?php while (have_rows('call_to_action_buttons')) {
                            the_row();
                            $ctaBtn = get_sub_field('button'); ?>
                            <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                            <?php
                        } ?>
                    </ul>
                </p>
            <?php } ?>
        </div>
    </div>
</section>
