<?php

get_header();
?>

<div <?php post_class('search-container'); ?>>
    <?php
    if (isset($_GET['lodge_search']) && $_GET['lodge_search'] == 1) { 
        //this is the lodges search
        ?>
        <section class="sale-plots">
            <div class="container-xxl">
                <div class="row">
                    <h1 class="search-title fw-bold text-uppercase">Lodges for Sale</h1>
                    
                    <?php if(have_posts()): ?>
                        <?php while(have_posts()): the_post(); ?>
                            <div class="col-md-3 mx-auto for-sale-card">
                                <?php
                                //this plot is still available
                                $saleDescription = get_field('lodge_description');
                                $locations = get_the_terms( get_the_ID(), 'locations' );
                                $location = $locations[0]->name;
                                $image = get_field('sale_image', get_the_ID());
                                $title = get_the_title();
                                $plotType = get_field('lodge_type', get_the_ID()); 
                                $price = get_field('lodge_price', get_the_ID());
                                $link = get_field('read_more_button', get_the_ID());
                                $linkTitle = $link['title'];
                                $linkURL = $link['url'];

                                if($linkURL == '') {
                                    $linkURL = get_permalink();
                                }

                                if($linkTitle == '') {
                                    $linkTitle = 'Learn More';
                                }
                                ?>
                                <div class="sale-image">
                                    <img src="<?= $image; ?>" alt="For Sale Image" />
                                </div>
                                <div class="sale-info">
                                    <span class="sale-title"><?= $title; ?> - <?= $location; ?></span>

                                    <div class="sale-type">
                                        <h4 class="fw-bold"><?= $plotType; ?></h4>
                                        <h4 class="fw-bold"> <?= '£' . $price; ?></h4>
                                    </div>
                                    <div class="sale-description">
                                        <?= $saleDescription; ?>
                                    </div>
                                    <div class="more-button">
                                        <a class="btn btn-primary" href="<?php echo esc_url( $linkURL ); ?>"><span><?= $linkTitle; ?></span></a>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; 
                        wp_reset_postdata();
                        ?>
                    <?php 
                    else : ?>
                        <br>
                        <p>We could not find any lodges for sale, this could be for the following reasons: </p>
                        <p>1. You submitted an empty search</p>
                        <p>2. There has been an error while searching for lodges.</p>
                        <p>3. We currently have no lodges for sale</p>
                        <br>
                        <p>If you believe there is an error with the search results please <a href="/contact-us">get in touch</a></p>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    <?php } else { 
        //standard search query
        ?>
        <section class="search-results">
            <div class="container-xxl">
                <div class="row">
                    <h1 class="search-title fw-bold text-uppercase"><?php printf( __( 'Search Results for: %s', 'shape' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
                    
                    <?php if ( have_posts() ) : ?>
                        <?php while ( have_posts() ) : the_post(); ?>
                            <a class="col-md-5" style="padding-top:20px; padding-bottom:20px;" href="<?= the_permalink(); ?>">
                                <img src="<?= the_post_thumbnail_url(); ?>" width="75" height="75" style="margin-right:15px;">
                                <?= get_the_title(); ?>
                            </a>
                        <?php endwhile; ?>
                    <?php else : ?>
                        <div class="image-container">
                            <img class="img-fluid d-block mx-auto" src="<?=get_template_directory_uri();?>/dist/images/no-results.png" />
                        </div>
                        
                        <p class="text-center">There was no results found for your query</p>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    <?php } ?>
</div>

<?php get_footer(); ?>