<?php
$tabBGColour = get_sub_field('accordion_tab_background_colour');
$tabTextColour = get_sub_field('accordion_tab_text_colour');
$activeTabBGColour = get_sub_field('active_accordion_tab_background_colour');
$activeTabTextColour = get_sub_field('active_accordion_tab_text_colour');
?>

<style>
    .accordion-button:not(.collapsed) {
        background-color: <?= $activeTabBGColour; ?>;
        color: <?= $activeTabTextColour; ?>;
    }

    .accordion-button {
        background-color: <?= $tabBGColour; ?>;
        color: <?= $tabTextColour; ?>;
    }
</style>

<section class="accordion-section">
    <?php
    $count = 1;
    if( have_rows('accordion_content') ): ?>
        <div class="container-xxl">
            <div class="row">
                <div class="accordion" id="ml_accordion">
                    <?php while( have_rows('accordion_content') ) : the_row();
                        $title = get_sub_field('title');
                        $content = get_sub_field('title'); ?>

                        <div class="accordion-item">
                            <h2 class="accordion-header" id="heading<?= $count; ?>">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?= $count; ?>" aria-expanded="true" aria-controls="collapse<?= $count; ?>">
                                    <?= $title; ?>
                                </button>
                            </h2>
                            <div id="collapse<?= $count; ?>" class="accordion-collapse collapse show" aria-labelledby="heading<?= $count; ?>" data-bs-parent="#ml_accordion">
                                <div class="accordion-body">
                                    <?= $content; ?>
                                </div>
                            </div>
                        </div>
                    <?php 
                    $count++;
                    endwhile; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
</section>