<?php
$lodgeFeatures = get_field('lodge_features');
$walkthrough = get_field('lodge_walkthrough');
$floorPlan = get_field('lodge_floor_plan');
?>

<section class="lodge-tab-section">
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-10">
                <ul class="nav nav-tabs" id="lodgeTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="key-features-tab" data-bs-toggle="tab" data-bs-target="#key-features" type="button" role="tab" aria-controls="key-features" aria-selected="true">Key Features</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="lodge-walkthrough-tab" data-bs-toggle="tab" data-bs-target="#lodge-walkthrough" type="button" role="tab" aria-controls="lodge-walkthrough" aria-selected="false">3D Walk Through</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="floor-layout-tab" data-bs-toggle="tab" data-bs-target="#floor-layout" type="button" role="tab" aria-controls="floor-layout" aria-selected="false">Floor Layout</button>
                    </li>
                </ul>
                <div class="tab-content" id="lodgeTabContent">
                    <div class="tab-pane fade show active" id="key-features" role="tabpanel" aria-labelledby="key-features-tab">
                        <?= $lodgeFeatures; ?>
                    </div>
                    <div class="tab-pane fade" id="lodge-walkthrough" role="tabpanel" aria-labelledby="lodge-walkthrough-tab">
                        <div class="matterport-container col-10 mx-auto">
                            <iframe class="col-10 mx-atuo" height="800" src="<?= $walkthrough; ?>" frameborder="0" allowfullscreen allow="xr-spatial-tracking"></iframe>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="floor-layout" role="tabpanel" aria-labelledby="floor-layout-tab">
                        <div class="col-10">
                            <img class="img-fluid mx-auto d-block" src="<?= $floorPlan; ?>" alt="Lodge Floor Plan" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>