<?php

use Blue2\Scruffy\Controllers\MapController;

$term = basename($_SERVER['REQUEST_URI']);

$sitePlan = get_field($term . '-site-map' , 'options');
$locationMap = get_field($term . '-location' , 'options');
$matterport = get_field($term . '-matterport-code' , 'options');

$args = array(  
    'post_type' => 'plot',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'tax_query' => array(
        array(
            'taxonomy' => 'locations',
            'field' => 'slug',
            'terms' => $term
        )
    )
);

$plots = new WP_Query( $args );

$lodgeInfo = Blue2\Scruffy\Controllers\MapController::getLodgeInfo($term);
?>

<section class="location-tab-section">
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-10">
                <ul class="nav nav-tabs" id="locationTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="lodges-for-sale-tab" data-bs-toggle="tab" data-bs-target="#lodges-for-sale" type="button" role="tab" aria-controls="lodges-for-sale" aria-selected="true">Lodges for Sale</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="site-plan-tab" data-bs-toggle="tab" data-bs-target="#site-plan" type="button" role="tab" aria-controls="site-plan" aria-selected="false">Site Plan</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="walkthrough-tab" data-bs-toggle="tab" data-bs-target="#walkthrough" type="button" role="tab" aria-controls="walkthrough" aria-selected="false">3D Walkthrough</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="price-list-tab" data-bs-toggle="tab" data-bs-target="#price-list" type="button" role="tab" aria-controls="price-list" aria-selected="false">Price List</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="location-tab" data-bs-toggle="tab" data-bs-target="#location" type="button" role="tab" aria-controls="location" aria-selected="false">Location</button>
                    </li>
                </ul>
                <div class="tab-content" id="locationTabContent">
                    <div class="tab-pane fade show active" id="lodges-for-sale" role="tabpanel" aria-labelledby="lodges-for-sale-tab">
                        <?php if( $plots->have_posts() ) { ?>
                            <div class="container-fluid for-sale-tab-container">
                                <div class="row">
                                    <?php while ( $plots->have_posts() ) : $plots->the_post();
                                        $saleStatus = get_field('plot_status', get_the_ID());

                                        if($saleStatus == 'sale') { ?>
                                            <div class="col-md-3 mx-auto for-sale-card">
                                                <?php
                                                //this plot is still available
                                                $saleDescription = get_field('sale_description');
                                                $locations = get_the_terms( get_the_ID(), 'locations' );
                                                $location = $locations[0]->name;
                                                $image = get_field('sale_image', get_the_ID());
                                                $title = get_the_title();
                                                $plotType = get_field('lodge_type', get_the_ID());
                                                $price = get_field('lodge_price', get_the_ID());
                                                $link = get_field('read_more_button', get_the_ID());
                                                $linkTitle = $link['title'];
                                                $linkURL = $link['url'];

                                                if($linkURL == '') {
                                                    $linkURL = get_permalink();
                                                }

                                                if($linkTitle == '') {
                                                    $linkTitle = 'Learn More';
                                                }
                                                ?>
                                                <div class="sale-image">
                                                    <img src="<?= $image; ?>" alt="For Sale Image" />
                                                </div>
                                                <div class="sale-info">
                                                    <span class="sale-title"><?= $title; ?> - <?= $location; ?></span>

                                                    <div class="sale-type">
                                                        <h4 class="fw-bold"><?= $plotType; ?></h4>
                                                        <h4 class="fw-bold"> <?= '£' . $price; ?></h4>
                                                    </div>
                                                    <div class="sale-description">
                                                        <?= $saleDescription; ?>
                                                    </div>
                                                    <div class="more-button">
                                                        <a class="btn btn-primary" href="<?php echo esc_url( $linkURL ); ?>"><span><?= $linkTitle; ?></span></a>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php }
                                    endwhile;

                                    wp_reset_postdata(); ?>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="container-fluid for-sale-tab-container">
                                <div class="row">
                                    <p>We currently have no plots for sale, please try again later</p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="tab-pane fade" id="site-plan" role="tabpanel" aria-labelledby="site-plan-tab">
                        <section class="area-map">
                            <img class="map img-fluid" src="<?= $sitePlan; ?>" alt="Map of location" />
                            <div class="lodge-pins">
                                <?php while ( $plots->have_posts() ) : $plots->the_post();
                                    $saleStatus = get_field('plot_status', get_the_ID());
                                    $saleDescription = get_field('sale_description');
                                    $locations = get_the_terms( get_the_ID(), 'locations' );
                                    $location = $locations[0]->name;
                                    $image = get_field('sale_image', get_the_ID());
                                    $title = get_the_title();
                                    $plotType = get_field('lodge_type', get_the_ID());
                                    $plotNumber = get_field('plot_number', get_the_ID());
                                    $price = get_field('lodge_price', get_the_ID());
                                    $linkURL = get_permalink();
                                    $linkTitle = 'Learn More';

                                    if($saleStatus == 'sale') {
                                        $status = 'For Sale';
                                    } elseif ($saleStatus == 'reserve') {
                                        $status = 'Reserved';
                                    } else {
                                        $status = 'Sold';
                                    }
                                    if(isset($plotNumber) && isset($plotType))
                                    { ?>
                                        <figure class="lodge lodge-<?= strtolower($plotType); ?>">
                                            <a class="lodge-link" href="#" onclick="return false;" style="left: <?= $lodgeInfo[$plotNumber]['left']; ?>; top: <?= $lodgeInfo[$plotNumber]['top']; ?>; transform: rotate(<?= $lodgeInfo[$plotNumber]['rotate']; ?>);">
                                                <img class="img-fluid" src="<?=get_template_directory_uri();?>/dist/images/target-<?= strtolower($plotType); ?>.svg" alt="target pin" />
                                            </a>
                                            <figcaption class="lodge-detail">
                                                <div class="lodge-sticky-panel">
                                                    <div class="close"><i class="fas fa-times"></i></div>
                                                    <img class="img-fluid" src="<?= $image; ?>" alt="For Sale Image" />

                                                    <div class="sale-info">

                                                        <span class="sale-title"><?= $title; ?> - <?= $location; ?></span> <br>

                                                        <span class="sale-stauts">Status: <?= $status; ?></span>

                                                        <div class="sale-type">
                                                            <h4 class="fw-bold"><?= $plotType; ?></h4>
                                                            <h4 class="fw-bold"> <?= '£' . $price; ?></h4>
                                                        </div>
                                                        <div class="sale-description d-none d-lg-block">
                                                            <?= $saleDescription; ?>
                                                        </div>
                                                        <div class="sale-description d-lg-none">
                                                            <?php
                                                                $raw_content 		= $saleDescription;
                                                                $trimmed_content	= wp_trim_words( $raw_content, '32' );
                                                                $clean_excerpt		= apply_filters( 'the_excerpt', $trimmed_content );
                                                                echo $clean_excerpt;
                                                            ?>
                                                        </div>
                                                        <div class="more-button">
                                                            <a class="btn btn-primary" href="<?php echo esc_url( $linkURL ); ?>"><span><?= $linkTitle; ?></span></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </figcaption>
                                        </figure>
                                    <?php }
                                endwhile;
                                wp_reset_postdata(); ?>
                            </div>
                        </section> 
                    </div>
                    <div class="tab-pane fade" id="walkthrough" role="tabpanel" aria-labelledby="walkthrough-tab">
                    <iframe class="col-10 mx-atuo" height="800" src="<?= $matterport; ?>" frameborder="0" allowfullscreen allow="xr-spatial-tracking"></iframe>
                    </div>
                    <div class="tab-pane fade" id="price-list" role="tabpanel" aria-labelledby="price-list-tab">
                        <?php if( $plots->have_posts() ) { ?>
                            <div class="container-fluid price-list-container">
                                <div class="row">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th scope="col">Plot</th>
                                                <th scope="col">Lodge Type</th>
                                                <th scope="col">Plot Size</th>
                                                <th scope="col">Bedrooms</th>
                                                <th scope="col">Price</th>
                                                <th scope="col"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php while ( $plots->have_posts() ) : $plots->the_post(); 
                                                $plotNumber = get_field('plot_number', get_the_ID());
                                                $plotType = get_field('lodge_type', get_the_ID()); 
                                                $plotSize = get_field('plot_size', get_the_ID());
                                                $bedrooms = get_field('number_of_bedrooms', get_the_ID());
                                                $price = get_field('lodge_price', get_the_ID());
                                                $link = get_permalink();
                                            ?>
                                                <tr>
                                                    <td><?= $plotNumber; ?></td>
                                                    <td><?= $plotType; ?></td>
                                                    <td><?= $plotSize; ?></td>
                                                    <td><?= $bedrooms; ?></td>
                                                    <td><?= $price; ?></td>
                                                    <td><a href="<?= $link; ?>">View</a></td>
                                                </tr>
                                            <?php endwhile;

                                            wp_reset_postdata(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="container-fluid">
                                <div class="row">
                                    <p>We have no price list to show you at the moment</p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="tab-pane fade" id="location" role="tabpanel" aria-labelledby="location-tab">
                        <div class="container-fluid for-sale-tab-container">
                            <div class="row">
                                <div class="col-10 d-flex justify-content-center">
                                    <?= $locationMap; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>