<?php
$bgImage = get_sub_field('background_image');

$args = array(  
    'post_type' => 'plot',
    'post_status' => 'publish',
    'posts_per_page' => -1
);

$lodges = new WP_Query( $args );

$bedrooms = [];
$types = [];
$resorts;

if( $lodges->have_posts() ) {
    while ( $lodges->have_posts() ) : $lodges->the_post();
        $saleStatus = get_field('plot_status', get_the_ID());

        if($saleStatus == 'sale') {
            $locations = get_the_terms( get_the_ID(), 'locations' );

            foreach($locations as $location) {
                $resorts[$location->name] = $location->name;
            }

            $lodgeType = get_field('lodge_type', get_the_ID());
            $lodgeBedrooms = get_field('number_of_bedrooms', get_the_ID());

            $types[$lodgeType] = $lodgeType;
            $bedrooms[$lodgeBedrooms] = $lodgeBedrooms;
        }
    endwhile;

    wp_reset_postdata();
}
?>

<section class="lodge-search-form" style="background-image: linear-gradient(rgba(0, 0, 0, 0.45), rgba(0, 0, 0, 0.45)), url('<?= $bgImage; ?>');">
    <div class="container">
        <div class="heading-text mx-auto">
            <p>Search Lodges for Sale</p>
        </div>
        
        <form role="search" class="mx-auto row row-cols-lg-auto g-3 align-items-center lodge-search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
            <div class="col-12 inner-sections">
                <div class="select-container">
                    <select name="bedrooms" id="bedrooms" class="minimal">
                        <option value="">Bedrooms</option>

                        <?php
                        foreach($bedrooms as $bedroom) {
                            if($bedroom == 1) { ?>
                                <option value="<?= $bedroom; ?>"><?= $bedroom; ?> Bedroom</option>
                            <?php } else { ?>
                                <option value="<?= $bedroom; ?>"><?= $bedroom; ?> Bedrooms</option>
                            <?php } 
                        } ?>
                    </select>
                </div>
            </div>

            <div class="col-12 inner-sections">
                <div class="select-container">
                    <select name="resort" id="resort" class="minimal">
                        <option value="">Resort</option>

                        <?php
                        foreach($resorts as $resort) { ?>
                            <option value="<?= $resort; ?>"><?= $resort; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>

            <div class="col-12 inner-sections">
                <div class="select-container last-select">
                    <select name="type" id="type" class="minimal">
                        <option value="">Lodge Type</option>

                        <?php
                        foreach($types as $type) { ?>
                            <option value="<?= $type; ?>"><?= $type; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>

            <div class="col-12 lodge-search-button">
                <button type="submit" class="btn btn-primary">Go</button>
            </div>

            <input type="hidden" name="lodge_search" value="1">
            <input type="hidden" name="s">
        </form>
    </div>
</section>