<?php
$term = basename($_SERVER['REQUEST_URI']);

$sitePlan = get_field($term . '-site-map' , 'options');
$locationMap = get_field($term . '-location' , 'options');
$matterport = get_field($term . '-matterport-code' , 'options');

$args = array(  
    'post_type' => 'plot',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'tax_query' => array(
        array(
            'taxonomy' => 'locations',
            'field' => 'slug',
            'terms' => $term
        )
    )
);

$plots = new WP_Query( $args );
?>

<section class="location-tab-section">
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-10">
                <ul class="nav nav-tabs" id="locationTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="lodges-for-sale-tab" data-bs-toggle="tab" data-bs-target="#lodges-for-sale" type="button" role="tab" aria-controls="lodges-for-sale" aria-selected="true">Lodges for Sale</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="site-plan-tab" data-bs-toggle="tab" data-bs-target="#site-plan" type="button" role="tab" aria-controls="site-plan" aria-selected="false">Site Plan</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="walkthrough-tab" data-bs-toggle="tab" data-bs-target="#walkthrough" type="button" role="tab" aria-controls="walkthrough" aria-selected="false">3D Walkthrough</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="price-list-tab" data-bs-toggle="tab" data-bs-target="#price-list" type="button" role="tab" aria-controls="price-list" aria-selected="false">Price List</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="location-tab" data-bs-toggle="tab" data-bs-target="#location" type="button" role="tab" aria-controls="location" aria-selected="false">Location</button>
                    </li>
                </ul>
                <div class="tab-content" id="locationTabContent">
                    <div class="tab-pane fade show active" id="lodges-for-sale" role="tabpanel" aria-labelledby="lodges-for-sale-tab">
                        <?php if( $plots->have_posts() ) { ?>
                            <div class="container-fluid for-sale-tab-container">
                                <div class="row">
                                    <?php while ( $plots->have_posts() ) : $plots->the_post();
                                        $saleStatus = get_field('plot_status', get_the_ID());

                                        if($saleStatus == 'sale') { ?>
                                            <div class="col-md-3 mx-auto for-sale-card">
                                                <?php
                                                //this plot is still available
                                                $saleDescription = get_field('sale_description');
                                                $locations = get_the_terms( get_the_ID(), 'locations' );
                                                $location = $locations[0]->name;
                                                $image = get_field('sale_image', get_the_ID());
                                                $title = get_the_title();
                                                $plotType = get_field('lodge_type', get_the_ID()); 
                                                $price = get_field('lodge_price', get_the_ID());
                                                $link = get_field('read_more_button', get_the_ID());
                                                $linkTitle = $link['title'];
                                                $linkURL = $link['url'];

                                                if($linkURL == '') {
                                                    $linkURL = get_permalink();
                                                }

                                                if($linkTitle == '') {
                                                    $linkTitle = 'Learn More';
                                                }
                                                ?>
                                                <div class="sale-image">
                                                    <img src="<?= $image; ?>" alt="For Sale Image" />
                                                </div>
                                                <div class="sale-info">
                                                    <span class="sale-title"><?= $title; ?> - <?= $location; ?></span>

                                                    <div class="sale-type">
                                                        <h4 class="fw-bold"><?= $plotType; ?></h4>
                                                        <h4 class="fw-bold"> <?= '£' . $price; ?></h4>
                                                    </div>
                                                    <div class="sale-description">
                                                        <?= $saleDescription; ?>
                                                    </div>
                                                    <div class="more-button">
                                                        <a class="btn btn-primary" href="<?php echo esc_url( $linkURL ); ?>"><span><?= $linkTitle; ?></span></a>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php }
                                    endwhile;

                                    wp_reset_postdata(); ?>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="container-fluid for-sale-tab-container">
                                <div class="row">
                                    <p>We currently have no plots for sale, please try again later</p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="tab-pane fade" id="site-plan" role="tabpanel" aria-labelledby="site-plan-tab">
                        <div class="container-fluid for-sale-tab-container">
                            <div class="row">
                                <div class="col-10">
                                    <img class="img-fluid d-block mx-auto" width="2470" height="2634" src="<?= $sitePlan; ?>" alt="Site Plan"  usemap="#site-plan-map"/>

                                    <map name="site-plan-map" id="site-plan-map">
                                        <area  class="available" alt="39" title="" shape="poly" coords="992,640,1051,666,1110,534,1054,508" style="outline:none;" />
                                        <area  class="available" alt="40" title="" shape="poly" coords="1213,231,1269,257,1215,374,1159,348" style="outline:none;" />
                                        <area  class="available" alt="41" title="" shape="poly" coords="1314,377,1372,401,1421,289,1365,261" style="outline:none;" />
                                        <area  class="available" alt="38" title="" shape="poly" coords="1139,659,1197,687,1247,574,1192,548" style="outline:none;" />
                                        <area  class="available" alt="42" title="" shape="poly" coords="1446,451,1501,480,1563,343,1507,318" style="outline:none;" />
                                        <area  class="available" alt="37" title="" shape="poly" coords="1291,666,1319,610,1431,663,1408,719" style="outline:none;" />
                                        <area  class="available" alt="36" title="" shape="poly" coords="1215,796,1241,741,1359,794,1332,848" style="outline:none;" />
                                        <area  class="available" alt="35" title="" shape="poly" coords="1146,926,1170,871,1302,931,1278,986" style="outline:none;" />
                                        <area  class="available" alt="1" title="" shape="poly" coords="1604,747,1651,789,1748,677,1699,635" style="outline:none;" />
                                        <area  class="available" alt="2" title="" shape="poly" coords="1697,856,1731,908,1839,841,1804,790" style="outline:none;" />
                                        <area  class="available" alt="3" title="" shape="poly" coords="1772,987,1803,1040,1916,974,1879,923" style="outline:none;" />
                                        <area  class="available" alt="5" title="" shape="poly" coords="1853,1192,1899,1148,1985,1242,1942,1280" style="outline:none;" />
                                        <area  class="available" alt="4" title="" shape="poly" coords="1969,1122,1984,1062,2125,1096,2110,1156" style="outline:none;"  />
                                        <area  class="" alt="34" title="" shape="poly" coords="1011,851,1068,877,1123,760,1068,735" style="outline:none;" />
                                        <area  class="" alt="33" title="" shape="poly" coords="862,805,918,830,972,718,914,692" style="outline:none;"  />
                                        <area  class="" alt="32" title="" shape="poly" coords="760,1090,816,1118,870,997,812,977" style="outline:none;"  />
                                        <area  class="" alt="31" title="" shape="poly" coords="899,1153,952,1181,1005,1063,949,1042" style="outline:none;"  />
                                        <area  class="" alt="30" title="" shape="poly" coords="1031,1220,1091,1247,1144,1130,1087,1104" style="outline:none;"  />
                                        <area  class="" alt="29" title="" shape="poly" coords="1188,1192,1214,1137,1331,1190,1304,1246" style="outline:none;"  />
                                        <area  class="" alt="28" title="" shape="poly" coords="1152,1268,1127,1322,1256,1385,1286,1329" style="outline:none;"  />
                                        <area  class="" alt="27" title="" shape="poly" coords="989,1422,1120,1480,1149,1427,1020,1370" style="outline:none;"  />
                                        <area  class="" alt="26" title="" shape="poly" coords="845,1367,903,1396,956,1280,898,1252" style="outline:none;"  />
                                        <area  class="" alt="25" title="" shape="poly" coords="707,1303,763,1329,818,1214,762,1189" style="outline:none;"  />
                                        <area  class="" alt="6" title="" shape="poly" coords="1727,1263,1770,1223,1858,1314,1811,1353" style="outline:none;"  />
                                        <area  class="" alt="7" title="" shape="poly" coords="1659,1404,1702,1365,1803,1469,1759,1509" style="outline:none;"  />
                                        <area  class="" alt="8" title="" shape="poly" coords="1567,1526,1613,1486,1700,1577,1655,1623" style="outline:none;"  />
                                        <area  class="" alt="9" title="" shape="poly" coords="1459,1632,1503,1593,1591,1682,1544,1723" style="outline:none;"  />
                                        <area  class="" alt="10" title="" shape="poly" coords="1324,1710,1370,1671,1471,1776,1423,1817" style="outline:none;"  />
                                        <area  class="" alt="11" title="" shape="poly" coords="1214,1814,1255,1773,1357,1879,1314,1920" style="outline:none;"  />
                                        <area  class="" alt="12" title="" shape="poly" coords="1126,1937,1168,1897,1257,1990,1208,2030" style="outline:none;" />
                                        <area  class="" alt="14" title="" shape="poly" coords="1014,2043,1060,2001,1144,2096,1101,2135" style="outline:none;" />
                                        <area  class="" alt="19" title="" shape="poly" coords="817,1883,861,1928,954,1842,910,1795" style="outline:none;"  />
                                        <area  class="" alt="24" title="" shape="poly" coords="922,1702,953,1645,1082,1706,1053,1760" style="outline:none;" />
                                        <area  class="" alt="23" title="" shape="poly" coords="770,1670,829,1696,880,1579,822,1556" style="outline:none;" />
                                        <area  class="" alt="22" title="" shape="poly" coords="634,1605,689,1632,743,1516,688,1492" style="outline:none;" />
                                        <area  class="" alt="20" title="" shape="poly" coords="662,1858,717,1886,774,1769,714,1742" style="outline:none;" />
                                        <area  class="" alt="21" title="" shape="poly" coords="528,1792,584,1819,637,1707,580,1675" style="outline:none;" />
                                        <area  class="" alt="18" title="" shape="poly" coords="525,2109,567,2153,675,2057,631,2011" style="outline:none;" />
                                        <area  class="" alt="17" title="" shape="poly" coords="667,2336,710,2296,812,2401,766,2445" style="outline:none;" />
                                        <area  class="" alt="16" title="" shape="poly" coords="782,2239,825,2198,912,2290,867,2329" style="outline:none;" />
                                        <area  class="" alt="15" title="" shape="poly" coords="891,2137,937,2096,1024,2185,977,2230" style="outline:none;" />
                                    </map>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="walkthrough" role="tabpanel" aria-labelledby="walkthrough-tab">
                    <iframe class="col-10 mx-atuo" height="800" src="<?= $matterport; ?>" frameborder="0" allowfullscreen allow="xr-spatial-tracking"></iframe>
                    </div>
                    <div class="tab-pane fade" id="price-list" role="tabpanel" aria-labelledby="price-list-tab">
                        <?php if( $plots->have_posts() ) { ?>
                            <div class="container-fluid price-list-container">
                                <div class="row">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th scope="col">Plot</th>
                                                <th scope="col">Lodge Type</th>
                                                <th scope="col">Plot Size</th>
                                                <th scope="col">Bedrooms</th>
                                                <th scope="col">Price</th>
                                                <th scope="col"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php while ( $plots->have_posts() ) : $plots->the_post(); 
                                                $plotNumber = get_field('plot_number', get_the_ID());
                                                $plotType = get_field('lodge_type', get_the_ID()); 
                                                $plotSize = get_field('plot_size', get_the_ID());
                                                $bedrooms = get_field('number_of_bedrooms', get_the_ID());
                                                $price = get_field('lodge_price', get_the_ID());
                                                $link = get_permalink();
                                            ?>
                                                <tr>
                                                    <td><?= $plotNumber; ?></td>
                                                    <td><?= $plotType; ?></td>
                                                    <td><?= $plotSize; ?></td>
                                                    <td><?= $bedrooms; ?></td>
                                                    <td><?= $price; ?></td>
                                                    <td><a href="<?= $link; ?>">View</a></td>
                                                </tr>
                                            <?php endwhile;

                                            wp_reset_postdata(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="container-fluid">
                                <div class="row">
                                    <p>We have no price list to show you at the moment</p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="tab-pane fade" id="location" role="tabpanel" aria-labelledby="location-tab">
                        <div class="container-fluid for-sale-tab-container">
                            <div class="row">
                                <div class="col-10 d-flex justify-content-center">
                                    <?= $locationMap; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>