<?php

$type = get_sub_field('slider_type');
$sliderTitle = get_sub_field('slider_title');

switch ($type) {
    case 'lodge':
        $sliders = get_sub_field('lodges');
        $slidesToShow = 3;
        break;
    case 'news':
        $sliders = get_sub_field('latest_news');
        $slidesToShow = 3;
        break;
    case 'events':
        $sliders = get_sub_field('events');
        $slidesToShow = 3;
        break;
    case 'post':
        $sliders = get_sub_field('posts');
        $slidesToShow = 3;
        break;
    case 'image':
        $sliders = get_sub_field('images');
        $slidesToShow = 3;
        break;
    case 'sale':
        $args = array(  
            'post_type' => 'lodge',
            'post_status' => 'publish',
            'posts_per_page' => -1
        );
        
        $sliders = new WP_Query( $args );
        $slidesToShow = 3;
        break;
    case 'custom':
        $sliders = get_sub_field('custom');
        $slidesToShow = 3;
        break;
}

if($sliders) { ?>
    <section class="slider-section">
        <div class="slider-content">

            <?php if($sliderTitle) { ?>
                <h2><?= $sliderTitle; ?></h2>
            <?php } ?>

            <div class="slider" data-slidesToShow="<?= $slidesToShow; ?>">
                <?php
                if( $type !== 'sale' ) {
                    foreach($sliders as $slide) {
                        $image = get_the_post_thumbnail_url( $slide['lodge']->ID, 'lodgeSlider');
                        $locations = get_the_terms( $slide['lodge']->ID, 'locations' );
                        $location = $locations[0]->name;
                        $location_id = get_cat_ID($location);
                        $location_link = get_category_link( $location_id );
                        $lodge = get_the_title( $slide['lodge']->ID );
                        $lodge_link = get_permalink($slide['lodge']->ID);
                        if($type == 'lodge') { ?>
                            <div>
                                <div class="lodge slider-card" style="background-image: linear-gradient(rgba(0, 0, 0, 0.45), rgba(0, 0, 0, 0.45)), url('<?= $image; ?>');">
                                    <div class="lodge-location">
                                        <a href="<?= $location_link; ?>"><?= $location; ?></a>
                                    </div>
                                    <div class="lodge-title">
                                        <h4><a href="<?= $lodge_link; ?>"><?= $lodge; ?></a></h4>
                                    </div>
                                </div>
                            </div>
                        <?php } elseif($type == 'news') { 
                            $image = get_the_post_thumbnail_url( $slide['news']->ID, 'article');
                            ?>
                            <div>
                                <div class="article slider-card">
                                    <div class="article-image">
                                        <a href="<?= get_permalink($slide['news']->ID); ?>">
                                            <img src="<?= $image; ?>" alt="Slider Image">
                                        </a>
                                    </div>
                                    <div class="article-date">
                                        <?= get_the_date( 'd F Y', $slide['news']->ID ); ?>
                                    </div>
                                    <div class="article-title">
                                        <a href="<?= get_permalink($slide['news']->ID); ?>"><?= get_the_title( $slide['news']->ID ); ?></a>
                                    </div>
                                    <div class="article-read-more">
                                        <a href="<?= get_permalink($slide['news']->ID); ?>">Read More</a>
                                    </div>
                                </div>
                            </div>
                        <?php } elseif($type == 'events') { 
                            $image = get_the_post_thumbnail_url( $slide['event']->ID, 'article');
                            ?>
                            <div>
                                <div class="event slider-card">
                                    <div class="event-image">
                                        <a href="<?= get_permalink($slide['event']->ID); ?>"><img class="img-fluid" src="<?= $image; ?>" alt="Slider Image"></a>
                                    </div>
                                    <div class="event-date">
                                        <?= get_the_date( 'd F Y', $slide['event']->ID ); ?>
                                    </div>
                                    <div class="event-title">
                                        <a href="<?= get_permalink($slide['event']->ID); ?>"><?= get_the_title( $slide['news']->ID ); ?></a>
                                    </div>
                                    <div class="event-read-more">
                                        <a href="<?= get_permalink($slide['event']->ID); ?>">Read More</a>
                                    </div>
                                </div>
                            </div>
                        <?php } elseif($type == 'post') { 
                            $image = get_the_post_thumbnail_url( $slide['post']->ID, 'article');
                            ?>
                            <div>
                                <div class="post slider-card">
                                    <div class="post-image">
                                        <a href="<?= get_permalink($slide['post']->ID); ?>"><img class="img-fluid" src="<?= $image; ?>" alt="Slider Image"></a>
                                    </div>
                                    <div class="post-date">
                                        <?= get_the_date( 'd F Y', $slide['post']->ID ); ?>
                                    </div>
                                    <div class="post-title">
                                        <a href="<?= get_permalink($slide['post']->ID); ?>"><?= get_the_title( $slide['post']->ID ); ?></a>
                                    </div>
                                    <div class="post-read-more">
                                        <a href="<?= get_permalink($slide['post']->ID); ?>">Read More</a>
                                    </div>
                                </div>
                            </div>
                        <?php } elseif($type == 'image') { 
                            $image = wp_get_attachment_url( $slide['image'] , 'slider' ); ?>
                            <div>
                                <div class="image">
                                    <img src="<?= $image; ?>" alt="Slider Image">
                                </div>
                            </div>
                        <?php }  elseif($type == 'custom') { 
                            $image = $image = wp_get_attachment_url( $slide['image'], 'slider');
                            $heading = $slide['heading'];
                            $caption = $slide['caption'];
                            ?>
                            <div>
                                <div class="custom slider-card" style="background-image: url('<?= $image; ?>');">
                                    <?php if($heading) { ?>
                                        <div class="custom-heading">
                                            <span><?= $heading; ?></span>
                                        </div>
                                    <?php } ?>
                                    
                                    <?php if($caption) { ?>
                                        <div class="custom-caption">
                                            <h4><?= $caption; ?></h4>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php }
                    } 
                } else {
                    if( $sliders->have_posts() ) { ?>
                        <div>
                        <?php while ( $sliders->have_posts() ) : $sliders->the_post();
                            $saleStatus = get_field('lodge_status');
        
                            if($saleStatus == 'sale') { ?>
                                <div class=" mx-auto sale slider-card">
                                    <?php
                                    //this plot is still available
                                    $saleDescription = get_field('lodge_description');
                                    $locations = get_the_terms( get_the_ID(), 'locations' );
                                    $location = $locations[0]->name;
                                    $image = get_field('sale_image', get_the_ID());
                                    $title = get_the_title();
                                    $plotType = get_field('lodge_type', get_the_ID()); 
                                    $price = get_field('lodge_price', get_the_ID());
                                    $link = get_permalink();
                                    ?>
                                    <div class="sale-image">
                                        <img src="<?= $image; ?>" alt="For Sale Image" />
                                    </div>
                                    <div class="sale-info">
                                        <span class="sale-title"><?= $title; ?> - <?= $location; ?></span>
                                        <div class="sale-lodge-info">
                                            <div class="col-5 sale-type">
                                                <h4 class="fw-bold"><?= $plotType; ?></h4>
                                            </div>
                                            <div class="col-5 sale-price">
                                                <h4 class="fw-bold"> <?= '£' . $price; ?></h4>
                                            </div>
                                        </div>
                                        <div class="sale-description">
                                            <?= $saleDescription; ?>
                                        </div>
                                        <div class="more-button">
                                            <a class="btn btn-primary" href="<?php echo esc_url( $link ); ?>"><span>Learn More</span></a>
                                        </div>
                                    </div>
                                </div>
                            <?php }
                        endwhile;
        
                        wp_reset_postdata(); ?>
                        </div>
                    <?php }
                } ?>
            </div>
            <div class="progress">
                <div class="bar"></div>
            </div>
        </div>
    </section>
<?php }
?>