<?php
namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);

        add_action('load_custom_scripts', [$this, 'mtnc_add_custom_scripts'], 15);
        add_action('load_custom_style', [$this, 'mtnc_add_custom_style'], 20);
    }

    private function setupControllers(){
        //Empty
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
    }

    public function mtnc_add_custom_scripts()
    {
        global $wp_scripts;

        wp_register_script( 'bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.bundle.min.js');
    
        $wp_scripts->do_items('bootstrap-js');
    }

    public function mtnc_add_custom_style()
    {
        global $wp_styles;

        wp_register_style('boptstrap-css','https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css');

        $wp_styles->do_items('boptstrap-css');
    }
}