<?php
$lodge = get_sub_field('featured_lodge');
$title = $lodge->post_title;
$image = wp_get_attachment_image_url( get_post_thumbnail_id( $lodge->ID ), 'banner' );
$description = apply_filters('the_content', get_post_field('post_content', $lodge->ID));
$price = get_field('lodge_price', $lodge->ID);
$link = get_permalink( $lodge->ID );
?>

<section class="featured-lodge">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-7 left-section">
                <img src="<?= $image; ?>" class="img-fluid" alt="<?= $title; ?>">
            </div>
            <div class="col-md-3 right-section">
                <p class="featured-title">
                    Featured Property
                </p>
                <h4 class="featured-lodge-title">
                    <?= $title; ?>
                </h4>
                <p class="featured-description">
                    <?= $description; ?>
                </p>
                <p class="featured-price text-end">
                    <?= '£' . $price; ?>
                </p>

                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                    <a class="btn btn-primary" href="<?= $link; ?>"><span>View</span></a>
                </div>
            </div>
        </div>
    </div>
</section>