<?php

namespace Blue2\Scruffy\Controllers;

class MaintenanceController
{
    public function __construct()
    {
        add_action('load_custom_scripts', [$this, 'mlv_add_custom_scripts'], 15);
        add_action('load_custom_style', [$this, 'mlv_add_custom_style'], 20);

        add_action( 'content_section', [$this, 'mlv_add_newsletter_form'], 20);
    }

    public function mlv_add_custom_scripts()
    {
        global $wp_scripts;

        wp_register_script( 'bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.bundle.min.js');
    
        $wp_scripts->do_items('bootstrap-js');
    }

    public function mlv_add_custom_style()
    {
        global $wp_styles;

        wp_register_style('boptstrap-css','https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css');

        $wp_styles->do_items('boptstrap-css');
    }

    public function mlv_add_newsletter_form()
    {
        ?>
        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?= '<script type="text/javascript" src="//app.icontact.com/icp/core/mycontacts/signup/designer/form/automatic?id=266&cid=1137618&lid=6997"></script>'; ?>
                </div>
                <div class="modal-footer">
                </div>
                </div>
            </div>
        </div>

        <?php
    }
}
