<?php

get_header();
?>

<div <?php post_class('search-container');?>>
    <div class="container-xxl">
        <div class="row">
            <div class="col-10">
                <h1 class="search-title fw-bold text-uppercase">Lodges for Sale</h1>
                
                <?php if(have_posts()): ?>
                    <section class="sale-plots">
                    <?php while(have_posts()): the_post(); ?>
                        <div class="col-md-3 mx-auto for-sale-card">
                            <?php
                            //this plot is still available
                            $saleDescription = get_field('sale_description');
                            $locations = get_the_terms( get_the_ID(), 'locations' );
                            $location = $locations[0]->name;
                            $image = get_field('sale_image', get_the_ID());
                            $title = get_the_title();
                            $plotType = get_field('lodge_type', get_the_ID()); 
                            $price = get_field('lodge_price', get_the_ID());
                            $link = get_permalink();
                            ?>
                            <div class="sale-image">
                                <img src="<?= $image; ?>" alt="For Sale Image" />
                            </div>
                            <div class="sale-info">
                                <span class="sale-title"><?= $title; ?> - <?= $location; ?></span>

                                <div class="sale-type">
                                    <h4 class="fw-bold"><?= $plotType; ?></h4>
                                    <h4 class="fw-bold"> <?= $price; ?></h4>
                                </div>
                                <div class="sale-description">
                                    <?= $saleDescription; ?>
                                </div>
                                <div class="more-button">
                                    <a class="btn btn-primary" href="<?php echo esc_url( $link ); ?>"><span>Learn More</span></a>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; 
                    wp_reset_postdata();
                    ?>
                    </section>
                <?php 
                else : ?>
                    <br>
                    <p>We could not find any lodges for sale, this could be for the following reasons: </p>
                    <p>1. You submitted an empty search</p>
                    <p>2. There has been an error while searching for lodges.</p>
                    <p>3. We currently have no lodges for sale</p>
                    <br>
                    <p>If you believe there is an error with the search results please <a href="/contact-us">get in touch</a></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>