<?php

$args = array(  
    'post_type' => 'experience',
    'post_status' => 'publish',
    'posts_per_page' => 10
);

$experiences = new WP_Query( $args ); ?>

<section class="experience-plots">
    <div class="container-xxl">
        <div class="row">
            <?php if( $experiences->have_posts() ) {
                while ( $experiences->have_posts() ) : $experiences->the_post(); 
                        $image = get_the_post_thumbnail_url(get_the_ID(),'card'); ?>
                        <div class="col-md-4 mx-auto experience-card d-flex align-items-end justify-content-center" style="background-image:url('<?= $image; ?>');">
                            <?php
                            $title = get_the_title();
                            $link = get_permalink();
                            ?>

                            <div class="d-grid gap-2 d-flex experience-button">
                                <a class="btn btn-primary" href="<?= $link; ?>"><span><?= $title; ?></span></a>
                            </div>
                        </div>
                <?php endwhile;

                wp_reset_postdata();
            } else { ?>
                <p>We currently have no experiences available, please try again later</p>
            <?php } ?>
        </div>
    </div>
</section