<?php
//get our experience information
$type = get_field('activity_type');
$groups = get_field('groups');
$map = get_field('google_maps_location');
$tel = get_field('telephone_number');
?>

<div <?php post_class("experience-single"); ?>>
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-4">
                <h4>Overview</h4>

                <div class="overview-title">
                    Activity Type
                </div>

                <div class="overview-info">
                    <?= $type; ?>
                </div>

                <div class="overview-title">
                    Groups
                </div>

                <div class="overview-title">
                    <?= $groups; ?>
                </div>

                <div class="overview-map">
                    <a class="btn btn-primary" href="<?php echo esc_url( $map  ); ?>" target="_blank"><span>View Map</span></a>
                </div>

                <div class="overview-telephone">
                    <p>Tob buy or register interest, please call:</p>
                    <p class="number"><?= $tel; ?></p>
                </div>
                
            </div>
            <div class="col-md-6">
 
                <h1><?= esc_html( get_the_title() );?></h1>
                <div class="single-content-container">
                    <?php the_content(); ?>
                </div>
            </div>
        </div>
    </div>

    <?php
    if(get_field('sections')) { ?>
        <div class="flexible-layout">
          <?php Blue2\Scruffy\Utils::flexibleLoop('sections'); ?>
        </div>
    <?php } ?>
</div>
