<?php
namespace Blue2\Scruffy;
use Blue2\Scruffy\Controllers\MaintenanceController;
use Blue2\Scruffy\Controllers\SiteController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_action('init', [$this, 'customImageSizes']);
        add_action('init', [$this, 'registerCustomTaxonomy']);

        add_action('init', [$this, 'customAdminPages']);

        add_filter( 'post_type_link', [$this,'change_plot_link'], 1, 3 );

        add_filter( 'register_post_type_args', [$this, 'change_post_slugs'], 10, 2 );

        add_action('parse_request', [$this, 'overwriteRequest'], 10, 1);


        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function overwriteRequest($query) {
        // If query doesn't contain locations, just return the query
        if (strpos($query->request, 'locations') === false) {
            return $query;
        } 

        if ( count($query->query_vars) > 0 && empty($query->query_vars['post_type'])) {
            // The request contains the string that was requested.
            $pageName = basename($query->request);
    
            // Check if post with the requested slug exists in your custom post type
            $plotResult = get_posts(array(
                'post_type' => 'plot',
                'name' => $pageName
            ));

            $experienceResult = get_posts(array(
                'post_type' => 'experience',
                'name' => $pageName
            ));

            if (count($experienceResult) < 1 && count($plotResult) < 1 ) {
                //never matched any of our requests
                return $query;
            } 
            
            if($plotResult) {
                dump('plot');
                $new_query = array(
                    'page' => '',
                    'plot' => $pageName,
                    'post_type' => 'plot',
                    'name' => $pageName
                );

                $query->query_vars = $new_query;
                return $query;
            } elseif($experienceResult) {
                $new_query = array(
                    'page' => '',
                    'experience' => $pageName,
                    'post_type' => 'experience',
                    'name' => $pageName
                );

                $query->query_vars = $new_query;
                return $query;
            }
            else {
                return $query;
            }
    
        } else {
            return $query;
        }
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'quick_links' => 'Quick Links',
            'help_links' => 'Help Links',
            'legal_links' => 'Footer Legal Links'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers(){
        new MaintenanceController();
        new SiteController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Lodge::registerPostType();
        Post\Plot::registerPostType();
        Post\Experience::registerPostType();
    }

    public function registerCustomTaxonomy() 
    {
        $labels = array(
            'name' => _x( 'Locations', 'taxonomy general name' ),
            'singular_name' => __( 'Locations', 'taxonomy singular name' ),
            'search_items' =>  __( 'Search Locations' ),
            'popular_items' => __( 'Popular Locations' ),
            'all_items' => __( 'All Locations' ),
            'parent_item' => null,
            'parent_item_colon' => null,
            'edit_item' => __( 'Edit Location' ), 
            'update_item' => __( 'Update Location' ),
            'add_new_item' => __( 'Add New Location' ),
            'new_item_name' => __( 'New Location Name' ),
            'separate_items_with_commas' => __( 'Separate locations with commas' ),
            'add_or_remove_items' => __( 'Add or remove locations' ),
            'choose_from_most_used' => __( 'Choose from the most used locations' ),
            'menu_name' => __( 'Locations' ),
        );
        
        register_taxonomy('locations',array('lodge','plot', 'experience'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'show_in_rest' => true,
            'show_admin_column' => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var' => true,
            'rewrite' => array( 'slug' => 'locations' ),
          ));
    }

    public function customImageSizes()
    {
        add_image_size('banner', '1920', '800', true);
        add_image_size('card', '500', '300', true);
        add_image_size('article', '530', '375', true);
        add_image_size('slider', '850', '850', true);
    }

    public function change_plot_link( $post_link, $id = 0 ) {
        $post = get_post( $id );
        if( $post->post_type == 'plot' || $post->post_type == 'experience' ) 
        {
           if ( is_object( $post ) ) {
              $terms = wp_get_object_terms( $post->ID, array('locations') );
              if ( $terms ) {
                 return str_replace( '%cat%', $terms[0]->slug, $post_link );
             }
          }
        }
        return   $post_link ;
    }

    public function change_post_slugs( $args, $post_type ) {

        if ( $post_type == 'plot') {
            $args['rewrite']['slug'] = 'locations/%cat%';
        }

        if ( $post_type == 'experience') {
            $args['rewrite']['slug'] = 'locations/%cat%/experiences';
        }

        return $args;
    }

    public function customAdminPages()
    {        
        $terms = get_terms( array(
            'taxonomy' => 'locations',
            'hide_empty' => false,
        ) );

        foreach($terms as $term) {
            if (function_exists('acf_add_options_page')) {
                // Add sub page.
                $options = acf_add_options_page(array(
                    'page_title'  => __($term->name . ' Settings'),
                    'menu_title'  => __($term->name),
                ));

                $termObjects = [];
                $acfLocations = [];

                $termObject = array(
                    'param' => 'options_page',
                    'operator' => '==',
                    'value' => 'acf-options-' . $term->slug,
                );

                $termObjects[] = $termObject;

                $acfLocations[] = $termObjects;
            }

            //add our options to our new parent pages
            if( function_exists('acf_add_local_field_group') ):
                acf_add_local_field_group(array(
                    'key' => $term->name . '-group',
                    'title' => 'Location Information',
                    'fields' => array(
                        array(
                            'key' => 'field_60c25a747e805',
                            'label' => 'Lodges for Sale',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'top',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_60c25a837e806',
                            'label' => 'Site Plan',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'top',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_60c25a937e807',
                            'label' => '3d Walk Through',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'top',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_60c25a9b7e808',
                            'label' => 'Price List',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'top',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_60c25ab27e809',
                            'label' => 'Location',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'top',
                            'endpoint' => 0,
                        ),
                    ),
                    'location' => $acfLocations,
                    'menu_order' => 0,
                    'position' => 'normal',
                    'style' => 'default',
                    'label_placement' => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen' => '',
                    'active' => true,
                    'description' => '',
                ));
                
            endif;
        }
    }
}