<?php

?>

<section class="location-tab-section">
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-10">
                <ul class="nav nav-tabs" id="locationTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="lodges-for-sale-tab" data-bs-toggle="tab" data-bs-target="#lodges-for-sale" type="button" role="tab" aria-controls="lodges-for-sale" aria-selected="true">Lodges for Sale</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="site-plan-tab" data-bs-toggle="tab" data-bs-target="#site-plan" type="button" role="tab" aria-controls="site-plan" aria-selected="false">Site Plan</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="3d-walkthrough-tab" data-bs-toggle="tab" data-bs-target="#3d-walkthrough" type="button" role="tab" aria-controls="3d-walkthrough" aria-selected="false">3d Walk Through</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="price-list-tab" data-bs-toggle="tab" data-bs-target="#price-list" type="button" role="tab" aria-controls="price-list" aria-selected="false">Price List</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="location-tab" data-bs-toggle="tab" data-bs-target="#location" type="button" role="tab" aria-controls="location" aria-selected="false">Location</button>
                    </li>
                </ul>
                <div class="tab-content" id="locationTabContent">
                    <div class="tab-pane fade show active" id="lodges-for-sale" role="tabpanel" aria-labelledby="lodges-for-sale-tab">
                        <?php $args = array(  
                            'post_type' => 'plot',
                            'post_status' => 'publish',
                            'posts_per_page' => 10
                        );

                        $plots = new WP_Query( $args );

                        if( $plots->have_posts() ) { ?>
                            <div class="container-fluid for-sale-tab-container">
                                <div class="row">
                                    <?php while ( $plots->have_posts() ) : $plots->the_post();
                                        $saleStatus = get_field('plot_status', get_the_ID());

                                        if($saleStatus == 'sale') { ?>
                                            <div class="col-md-4 mx-auto for-sale-card">
                                                <?php
                                                //this plot is still available
                                                $saleDescription = get_field('sale_description');
                                                $locations = get_the_category(get_the_ID());
                                                $location = $locations[0]->cat_name;
                                                $image = get_field('sale_image', get_the_ID());
                                                $title = get_the_title();
                                                $plotType = get_field('lodge_type', get_the_ID()); 
                                                $price = get_field('lodge_price', get_the_ID());
                                                $link = get_permalink();
                                                ?>
                                                <div class="sale-image">
                                                    <img src="<?= $image; ?>" alt="For Sale Image" />
                                                </div>
                                                <div class="sale-info">
                                                    <span class="sale-title"><?= $title; ?> - <?= $location; ?></span>

                                                    <div class="sale-type">
                                                        <h4 class="fw-bold"><?= $plotType; ?></h4>
                                                        <h4 class="fw-bold"> <?= $price; ?></h4>
                                                    </div>
                                                    <div class="sale-description">
                                                        <?= $saleDescription; ?>
                                                    </div>
                                                    <div class="more-button">
                                                        <a class="btn btn-primary" href="<?php echo esc_url( $link ); ?>"><span>Learn More</span></a>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php }
                                    endwhile;

                                    wp_reset_postdata();
                                } else { ?>
                                    <p>We currently have no plots for sale, please try again later</p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="site-plan" role="tabpanel" aria-labelledby="site-plan-tab">

                    </div>
                    <div class="tab-pane fade" id="3d-walkthrough" role="tabpanel" aria-labelledby="3d-walkthrough-tab">

                    </div>
                    <div class="tab-pane fade" id="price-list" role="tabpanel" aria-labelledby="price-list-tab">
                        <div class="container-fluid price-list-container">
                            <div class="row">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th scope="col">Plot</th>
                                            <th scope="col">Lodge Type</th>
                                            <th scope="col">Plot Size</th>
                                            <th scope="col">Bedrooms</th>
                                            <th scope="col">Price</th>
                                            <th scope="col"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>1</td>
                                            <td>Westfield</td>
                                            <td>62Sqm</td>
                                            <td>2</td>
                                            <td>£69,000</td>
                                            <td>View</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="location" role="tabpanel" aria-labelledby="location-tab">

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>