<?php
//get our lodge information
$bedrooms = get_field('number_of_bedrooms');
$bathrooms = get_field('number_of_bathrooms');
$tel = get_field('telephone_number');
$locations = get_field('available_locations');
$price = get_field('lodge_price');
?>

<div <?php post_class("lodge-single"); ?>>
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-4">
                <h4>Overview</h4>

                <div class="overview-title">
                    Available Locations
                </div>

                <div class="overview-info">
                    <?= $locations; ?>
                </div>

                <div class="overview-title">
                    Bedrooms
                </div>

                <div class="overview-title">
                    <?= $bedrooms; ?>
                </div>

                <div class="overview-title">
                    Bathrooms
                </div>

                <div class="overview-title">
                    <?= $bathrooms; ?>
                </div>

                <div class="overview-availability">
                    <a class="btn btn-secondary" href="<?php echo esc_url( $map  ); ?>"><span>Available Plots</span></a>
                </div>

                <div class="overview-enquiry">
                    <a class="btn btn-primary" href="<?php echo esc_url( $map  ); ?>"><span>Enquire</span></a>
                </div>
                
            </div>
            <div class="col-md-6">
                <div class="row">
                    <div class="col-7">
                        <h2 class="fw-bold"><?= wp_title('');?></h2>
                    </div>
                    <div class="col-3">
                        <h2 class="fw-bold"><?= '£'. $price; ?></h2>
                    </div>
                </div>
                <div class="single-content-container">
                    <?php the_content(); ?>
                </div>

                <div class="request-brochure">
                    <a class="btn btn-secondary" href="<?php echo esc_url( $map  ); ?>"><span>Request a Brochure</span></a>
                </div>
            </div>
        </div>
    </div>

    <?php
    if(get_field('sections')) { ?>
        <div class="flexible-layout">
          <?php Blue2\Scruffy\Utils::flexibleLoop('sections'); ?>
        </div>
    <?php } ?>
</div>
