<?php
namespace Blue2\Scruffy;
use Blue2\Scruffy\Controllers\MaintenanceController;
use Blue2\Scruffy\Controllers\SiteController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_action('init', [$this, 'customImageSizes']);
        add_action('init', [$this, 'registerCustomTaxonomy']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'quick_links' => 'Quick Links',
            'help_links' => 'Help Links',
            'legal_links' => 'Footer Legal Links'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers(){
        new MaintenanceController();
        new SiteController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Lodge::registerPostType();
        Post\Plot::registerPostType();
        Post\Experience::registerPostType();
    }

    public function registerCustomTaxonomy() 
    {
        $labels = array(
            'name' => _x( 'Locations', 'taxonomy general name' ),
            'singular_name' => __( 'Location', 'taxonomy singular name' ),
            'search_items' =>  __( 'Search Locations' ),
            'popular_items' => __( 'Popular Locations' ),
            'all_items' => __( 'All Locations' ),
            'parent_item' => null,
            'parent_item_colon' => null,
            'edit_item' => __( 'Edit Location' ), 
            'update_item' => __( 'Update Location' ),
            'add_new_item' => __( 'Add New Location' ),
            'new_item_name' => __( 'New Location Name' ),
            'separate_items_with_commas' => __( 'Separate locations with commas' ),
            'add_or_remove_items' => __( 'Add or remove locations' ),
            'choose_from_most_used' => __( 'Choose from the most used locations' ),
            'menu_name' => __( 'Location' ),
        );
        
        register_taxonomy('location',array('lodge','plot', 'experience'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'show_in_rest' => true,
            'show_admin_column' => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var' => true,
            'rewrite' => array( 'slug' => 'location' ),
          ));
    }

    public function customImageSizes()
    {
        add_image_size('banner', '1920', '800', true);
        add_image_size('card', '500', '300', true);
        add_image_size('article', '530', '375', true);
        add_image_size('slider', '850', '850', true);
    }
}