<?php
$panelType = get_sub_field('panel_type');
$image = wp_get_attachment_url( get_sub_field( "panel_image" ) , 'banner' );
$title = get_sub_field('panel_title');
$description = get_sub_field('panel_description');
$button = get_sub_field('panel_read_more_button');
$setHeight =  get_sub_field('set_section_height');
$sectionHeight = get_sub_field('section_height');

switch ($panelType) {
    case 'image-left':
        $leftSize = 'col-md-7';
        $rightSize = 'col-md-3';
        break;
    case 'image-right':
        $leftSize = 'col-md-3';
        $rightSize = 'col-md-7';
        break;
}
?>
<section class="container-fluid lodge-panel" style="<?php if ($setHeight == 'True') { ?>height:<?= $sectionHeight; ?>px; <?php } ?>">
    <div class="row">
        <div class="left-column cms <?= $leftSize; ?>">
            <?php if($panelType == 'image-left') { ?>
                <img src="<?= $image; ?>" alt="Lodge image">
            <?php } else { ?>
                <h2><?= $title; ?></h2>
                <p><?= $description; ?></p>
                <a class="btn btn-primary" href="<?= $button['url']; ?>"><span><?= $button['title']; ?></span></a>
            <?php } ?>
        </div>
        <div class="right-column cms <?= $rightSize; ?>">
            <?php if($panelType == 'image-right') { ?>
                <img src="<?= $image; ?>" alt="Lodge image">
            <?php } else { ?>
                <h2><?= $title; ?></h2>
                <p><?= $description; ?></p>
                <a class="btn btn-primary" href="<?= $button['url']; ?>"><span><?= $button['title']; ?></span></a>
            <?php } ?>
        </div>
    </div>
</section>