<?php

namespace Blue2\Scruffy\Controllers;

class MaintenanceController
{
    public function __construct()
    {
        add_action('load_custom_scripts', [$this, 'mlv_add_custom_scripts'], 15);
        add_action('load_custom_style', [$this, 'mlv_add_custom_style'], 20);

        add_action( 'content_section', [$this, 'mlv_add_newsletter_form'], 20);
    }

    public function mlv_add_custom_scripts()
    {
        global $wp_scripts;

        wp_register_script( 'bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.bundle.min.js');

        wp_register_script( 'icontact-tracking-js', 'https://app.icontact.com/icp/static/form/javascripts/tracking.js');

        wp_register_script( 'icontact-js', 'https://app.icontact.com/icp/static/form/javascripts/validation-captcha.js');
    
        $wp_scripts->do_items('bootstrap-js');

        $wp_scripts->do_items('icontact-tracking-js');

        $wp_scripts->do_items('icontact-js');
    }

    public function mlv_add_custom_style()
    {
        global $wp_styles;

        wp_register_style('boptstrap-css','https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css');

        wp_register_style('icontact-css','https://app.icontact.com/icp/static/human/css/signupBuilder/formGlobalStyles.css');

        $wp_styles->do_items('boptstrap-css');

        $wp_styles->do_items('icontact-css');
    }

    public function mlv_add_newsletter_form()
    {
        ?>
        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?= '<form id="ic_signupform" captcha-key="6LeCZCcUAAAAALhxcQ5fN80W6Wa2K3GqRQK6WRjA" captcha-theme="light" new-captcha="true" method="POST" action="https://app.icontact.com/icp/core/mycontacts/signup/designer/form/?id=266&cid=1137618&lid=6997"><div class="elcontainer normal inline-label-left left-aligned"><div class="form-header"><h3>Join the Mailing List</h3></div><div class="sortables"><p style="color:black;">We have so much in store! Don\'t miss out on any news by signining up to our mailing list. We promise it will be worth it</p><div class="formEl fieldtype-input required" style="display: inline-block; width: 100%;" data-validation-type="1" data-label="First Name"><label>First Name<span class="indicator required">*</span></label><input type="text" placeholder="" name="data[fname]"></div><div class="formEl fieldtype-input required" style="display: inline-block; width: 100%;" data-validation-type="1" data-label="Last Name"><label>Last Name<span class="indicator required">*</span></label><input type="text" placeholder="" name="data[lname]"></div><div class="formEl fieldtype-input required" style="display: inline-block; width: 100%;" data-validation-type="1" data-label="Email Address"><label>Email Address<span class="indicator required">*</span></label><input type="text" placeholder="" name="data[email]"></div><div class="formEl fieldtype-checkbox required" dataname="listGroups" style="display: none; width: 100%;" data-validation-type="1" data-label="Lists"><h3>Lists<span class="indicator required">*</span></h3><div class="option-container"><label class="checkbox"><input type="checkbox" alt="" name="data[listGroups][]" value="111610" checked="checked">Morris Leslie Villages Newsletter</label></div></div><div class="submit-container"><input type="submit" value="Submit" class="btn btn-submit"></div></div><div class="hidden-container"></div></div></form><img src="//app.icontact.com/icp/core/signup/tracking.gif?id=null&cid=1137618&lid=6997"/>'; ?>
                </div>
                <div class="modal-footer">
                </div>
                </div>
            </div>
        </div>

        <?php
    }
}
