<header class="header-container">
    <div class="container-fluid">
        <div class="row header-navbar">
            <div class="col-2 text-center nav-menu">
                <div class="hamburger">
                    <div class="bars">
                        <div class="bar1"></div>
                        <div class="bar2"></div>
                        <div class="bar3"></div>
                    </div>
                    <div class="burger-title">
                        <span>Menu</span>
                    </div>
                </div>
            </div>

            <div class="col-2 d-none d-md-flex nav-left-link">
                <?php $leftLink = get_field('left_navbar_link', 'options'); 
                
                if( $leftLink ): 
                    $link_url = $leftLink['url'];
                    $link_title = $leftLink['title'];
                    $link_target = $leftLink['target'] ? $link['target'] : '_self';
                ?>
                    <a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php else: ?>
                    <a href="" target=""></a>
                <?php endif; ?>
            </div>

            <div class="col-6 col-md-2 nav-logo">
                <?php $navLogo = get_field('navbar_logo', 'options');
                $mobileLogo = get_field('mobile_navbar_logo', 'options');

                if( !empty( $navLogo ) ): ?>
                    <img class="d-none d-md-block mx-auto" src="<?php echo esc_url($navLogo['url']); ?>" alt="<?php echo esc_attr($navLogo['alt']); ?>" height="75" />
                <?php else: ?>
                    <img class="d-none d-md-block mx-auto" src="" height="75" />
                <?php endif; 

                if( !empty( $mobileLogo ) ): ?>
                    <img class="d-block d-md-none mx-auto" src="<?php echo esc_url($mobileLogo['url']); ?>" alt="<?php echo esc_attr($mobileLogo['alt']); ?>" height="75" />
                <?php else: ?>
                    <img class="d-block d-md-none mx-auto" src="" height="75" />
                <?php endif; ?>
            </div>

            <div class="col-2 d-none d-md-flex nav-right-link">
                <?php $rightLink = get_field('right_navbar_link', 'options'); 

                if( $rightLink ): 
                    $link_url = $rightLink['url'];
                    $link_title = $rightLink['title'];
                    $link_target = $rightLink['target'] ? $link['target'] : '_self';
                ?>
                
                    <a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php else: ?>
                    <a href="" target=""></a>
                <?php endif; ?>
            </div>

            <div class="col-2 nav-call-to-action">
                <?php $ctaLink = get_field('nav_cta', 'options'); 

                if( $ctaLink ): 
                    $link_url = $ctaLink['url'];
                    $link_title = $ctaLink['title'];
                    $link_target = $ctaLink['target'] ? $link['target'] : '_self';
                ?>
                    <i class="fas fa-at d-block d-md-none"></i>
                    <a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php else: ?>
                    <a href="" target=""></a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="menu-overlay">
        <div class="overlay-contents">
            <?php 
                wp_nav_menu( 
                    [
                        'theme_location' => 'main_menu',
                        'menu_class' => 'overlay-menu'
                    ]
                ); 
            ?>

            <div class="input-group">
                <input class="form-control py-2 border-end-0 border rounded-start" type="search" placeholder="Search" id="search-input">
                <span class="input-group-append">
                    <div class="input-group-text bg-white rounded-end">
                        <i class="fa fa-search"></i>
                    </div>
                </span>
            </div>

            <div class="overlay-social-navigation">
                <?php if (have_rows('social_media_channels', 'option')) { ?>
                    <ul class="overlay-navigation">
                        <?php
                        while (have_rows('social_media_channels', 'option')) {
                            the_row(); ?>
                            <li><a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
        </div>
    </div>
    
    <?php if(get_field( "banner_image" )) {
        $bannerImage = wp_get_attachment_url( get_field( "banner_image" ) , 'banner' );
    } else {
        $bannerImage = '';
    }

    if(get_field( "content_position" )) {
        $bannerAlign =  get_field( "content_position" );
    }

    $group = get_field('banner_content');

    if( get_field( "banner_image" ) || $group['banner_text'] || $group['call_to_action_buttons']) {
        //we have content, now run the rows

        if (have_rows('banner_content')) { ?>
            <div class="jumbotron jumbotron-fluid banner" style="background-image:url('<?= $bannerImage; ?>');">
                <div class="container banner-content <?= $bannerAlign; ?>">
                    <?php while (have_rows('banner_content')) {
                        the_row(); 
                        $bannerText = get_sub_field('banner_text');
                        ?>
    
                        <h1 class="display-5 banner-header"><?= $bannerText; ?></h1>
    
                        <?php if (have_rows('call_to_action_buttons')) { ?>
                            <p class="lead">
                                <ul class="cta-btn-row">
                                    <?php while (have_rows('call_to_action_buttons')) {
                                        the_row();
                                        $ctaBtn = get_sub_field('button'); ?>
                                        <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                                        <?php
                                    } ?>
                                </ul>
                            </p>
                            <?php
                        } ?>
                    <?php } ?>
                </div>
            </div>
        <?php }
    } ?>
</header>

<main id="content">