<?php
use Blue2\Scruffy\Controllers\SiteController;
?>

<footer class="site-footer">
    <div class="container-fluid">
        <div class="row">
            <div class="sign-up-form">
                <div class="col-md-4 mx-auto text-center">
                    <form id="ic_signupform" captcha-key="6LeCZCcUAAAAALhxcQ5fN80W6Wa2K3GqRQK6WRjA" captcha-theme="light" new-captcha="true" method="POST" action="https://app.icontact.com/icp/core/mycontacts/signup/designer/form/?id=266&cid=1137618&lid=6997">
                        <div class="elcontainer normal inline-label-left left-aligned">
                            <div class="form-header">
                                <p class="sign-up-text">Sign up for News</p>
                                <h3>Join the mailing list</h3>
                            </div>
                            <div class="sortables">
                                <p class="intro-text">We have so much in store! Don't miss out on any news by signining up to our mailing list. We promise it will be worth it</p>
                                <div class="formEl fieldtype-input required" style="display: inline-block; width: 100%;" data-validation-type="1" data-label="First Name">
                                    <label>First Name<span class="indicator required">*</span></label>
                                    <input type="text" placeholder="" name="data[fname]">
                                </div>
                                <div class="formEl fieldtype-input required" style="display: inline-block; width: 100%;" data-validation-type="1" data-label="Last Name">
                                    <label>Last Name<span class="indicator required">*</span></label>
                                    <input type="text" placeholder="" name="data[lname]">
                                </div>
                                <div class="formEl fieldtype-input required" style="display: inline-block; width: 100%;" data-validation-type="1" data-label="Email Address">
                                    <label>Email Address<span class="indicator required">*</span></label>
                                    <input type="text" placeholder="" name="data[email]">
                                </div>
                                <div class="formEl fieldtype-checkbox required" dataname="listGroups" style="display: none; width: 100%;" data-validation-type="1" data-label="Lists">
                                    <h3>Lists<span class="indicator required">*</span></h3>
                                    <div class="option-container">
                                        <label class="checkbox">
                                        <input type="checkbox" alt="" name="data[listGroups][]" value="111610" checked="checked">Morris Leslie Villages Newsletter</label>
                                    </div>
                                </div>
                                <div class="submit-container">
                                    <input type="submit" value="Submit" class="btn btn-submit">
                                </div>
                            </div>
                            <div class="hidden-container">
                            </div>
                        </div>
                    </form>
                    <img src="//app.icontact.com/icp/core/signup/tracking.gif?id=null&cid=1137618&lid=6997"/>
                </div>
            </div>
        </div>
    </div>
    
    <div class=" footer-bottom">
        <div class="container-xxl">
            <div class="row top-section">
                <div class="col-lg-3 col-10 footer-logo">
                    <?php $footerLogo = get_field('footer_logo', 'options');

                    if( !empty( $footerLogo ) ): ?>
                        <img src="<?php echo esc_url($footerLogo['url']); ?>" alt="<?php echo esc_attr($footerLogo['alt']); ?>" height="116" />
                    <?php else: ?>
                        <img src="" height="116" />
                    <?php endif; ?>
                </div>

                <div class="col-lg-2 col-5 quick-links">
                    <p class="menu-title">Quick Links</p>

                    <?php
                        wp_nav_menu( 
                            [
                                'theme_location' => 'quick_links',
                                'menu_class' => 'quick-links-menu'
                            ]
                        );
                    ?>
                </div>

                <div class="col-lg-2 col-5 help-links">
                    <p class="menu-title">Help Links</p>

                    <?php
                        wp_nav_menu( 
                            [
                                'theme_location' => 'help_links',
                                'menu_class' => 'help-links-menu'
                            ]
                        );
                    ?>
                </div>

                <div class="col-lg-3 col-10 footer-address">
                    <div class="address">
                        <?php 
                        $companyName = get_field('company_name', 'options'); 
                        $companyAddress = get_field('company_address', 'options');
                        $companyEmail = get_field('contact_email_address', 'options');
                        $companyPhone = get_field('contact_phone_number', 'options');
                        ?>

                        <?= $companyName; ?><br><br>
                        <?= $companyAddress; ?><br><br>
                        Tel: <?= $companyPhone; ?><br>
                        Email: <?= $companyEmail; ?><br>
                    </div>

                    <div class="socials">
                        <?php if (have_rows('social_media_channels', 'option')) { ?>
                            <ul class="footer-socials">
                                <?php
                                while (have_rows('social_media_channels', 'option')) {
                                    the_row(); ?>
                                    <li><a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a></li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <div class="row bottom-section">
                <div class="col-lg-5 col-10 legal">
                    <p class="copyright-text">Copyright &copy; <?php SiteController::auto_copyright('2021'); ?> <?= get_bloginfo( 'name' ); ?></p>
                    
                    <?php
                        wp_nav_menu( 
                            [
                                'theme_location' => 'legal_links',
                                'menu_class' => 'legal-links'
                            ]
                        );
                    ?>
                </div>

                <div class="col-lg-5 col-10 powered-by">
                    <P class="powered-by-text text-end">Website Powered By <a href="https:www.blue2.com">Blue2</a>
                </div>
            </div>
        </div>
    </div>
</footer>