<?php
namespace Blue2\Scruffy;
use Blue2\Scruffy\Controllers\MaintenanceController;
use Blue2\Scruffy\Controllers\SiteController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_action('init', [$this, 'customImageSizes']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'quick_links' => 'Quick Links',
            'help_links' => 'Help Links',
            'legal_links' => 'Footer Legal Links'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers(){
        new MaintenanceController();
        new SiteController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Lodge::registerPostType();
        Post\Plot::registerPostType();
        Post\Experience::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('banner', '1920', '800', true);
        add_image_size('card', '500', '300', true);
        add_image_size('slider', '850', '850', true);
    }
}