<div class="container-fluid mapStrip">
    <div class="mapHeader">
        <h2 class="scriptHead">The Penguin Parade</h2>
    </div>
    <div id="trailMap">
    </div>
</div>
<?php
$penguins = new WP_Query();

$args = array(
    'posts_per_page' => -1,
    'post_status' => "publish",
    'post_type' => "penguins",
    'orderby' => "post_date"
);
$penguins->query($args);


if (have_posts()) {

    ?>
    <script>
        if (jQuery('#trailMap').length > 0) {
            console.log('test');

            google.maps.event.addDomListener(window, 'load', init);
            var map;

            function init() {
                var mapOptions = {
                    center: new google.maps.LatLng(56.5178621, -2.9766745),
                    zoom: 12,
                    zoomControl: true,
                    zoomControlOptions: {
                        style: google.maps.ZoomControlStyle.DEFAULT,
                    },
                    disableDoubleClickZoom: true,
                    mapTypeControl: true,
                    mapTypeControlOptions: {
                        style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
                    },
                    scaleControl: true,
                    scrollwheel: false,
                    panControl: true,
                    streetViewControl: true,
                    draggable: true,
                    overviewMapControl: true,
                    overviewMapControlOptions: {
                        opened: false,
                    },
                    mapTypeId: google.maps.MapTypeId.ROADMAP,
                };
                var mapElement = document.getElementById('trailMap');
                var map = new google.maps.Map(mapElement, mapOptions);
                var locations = [
                    <?php
                    while ($penguins->have_posts()) {
                    $penguins->the_post();
                    $location = get_field('lat_long');
                    if (has_post_thumbnail()) {
                        $feat_image_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'small-pic')[0];
                    } ?>

                    ['<?php the_title(); ?>', 'undefined', 'undefined', 'undefined', '<?php the_permalink(); ?>', <?=$location['lat']?>, <?=$location['lng']?>, '<?php echo $feat_image_url; ?>'],
                    <?php } ?>
                ];
                for (i = 0; i < locations.length; i++) {
                    if (locations[i][1] == 'undefined') {
                        description = '';
                    } else {
                        description = locations[i][1];
                    }
                    if (locations[i][2] == 'undefined') {
                        telephone = '';
                    } else {
                        telephone = locations[i][2];
                    }
                    if (locations[i][3] == 'undefined') {
                        email = '';
                    } else {
                        email = locations[i][3];
                    }
                    if (locations[i][4] == 'undefined') {
                        web = '';
                    } else {
                        web = locations[i][4];
                    }
                    if (locations[i][7] == 'undefined') {
                        markericon = '';
                    } else {
                        markericon = locations[i][7];
                    }
                    marker = new google.maps.Marker({
                        icon: markericon,
                        position: new google.maps.LatLng(locations[i][5], locations[i][6]),
                        map: map,
                        title: locations[i][0],
                        desc: description,
                        tel: telephone,
                        email: email,
                        web: web
                    });
                    link = '';
                    bindInfoWindow(marker, map, locations[i][0], description, telephone, email, web, link);
                }

                function bindInfoWindow(marker, map, title, desc, telephone, email, web, link) {
                    var infoWindowVisible = (function () {
                        var currentlyVisible = false;
                        return function (visible) {
                            if (visible !== undefined) {
                                currentlyVisible = visible;
                            }
                            return currentlyVisible;
                        };
                    }());
                    iw = new google.maps.InfoWindow();
                    google.maps.event.addListener(marker, 'click', function () {
                        if (infoWindowVisible()) {
                            iw.close();
                            infoWindowVisible(false);
                        } else {
                            var html = "<div><h3>" + title + "</h3><p><br></div><a class='text-center map-btn' href='" + web + "' title='View the " + title + " sculpture'>View Sculpture</a></p></div>";
                            iw = new google.maps.InfoWindow({content: html});
                            iw.open(map, marker);
                            infoWindowVisible(true);
                        }
                    });
                    google.maps.event.addListener(iw, 'closeclick', function () {
                        infoWindowVisible(false);
                    });
                }

                google.maps.event.addListener(map, 'click', function (event) {
                    this.setOptions({scrollwheel: true});
                });
                google.maps.event.addListener(map, 'mouseout', function (event) {
                    this.setOptions({scrollwheel: false});
                });
            }
        }
        ;
    </script>
<?php } else {
} ?>