<div class="container-fluid mapStrip">
	<div class="mapHeader">
		<h2 class="scriptHead">The Bucket Trail</h2>
	</div>
	<div id="trailMap">
	</div>
</div>
<?php 
	$penguins = new WP_Query();
	
	$args = array(
	'post_limit' => -1,
	'post_status' => "publish",
	'post_type' => "penguins",
	'orderby' => "post_date"
	);
	$penguins->query($args);
	
    if (have_posts()) {
	?>
	<script>
	var geocoder;
	var map;
	var bounds = new google.maps.LatLngBounds();
	var locations = [
	<?php
		while ($penguins->have_posts()) {
		$penguins->the_post();
		if ( has_post_thumbnail() ) { $feat_image_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'small-pic')[0]; } else {}
		$locationVar = "['".get_the_title()."', '".get_field('lat_long')."', '".get_the_permalink()."', '". $feat_image_url ."'],";
	?>
		<?php echo $locationVar; ?>
	<?php } ?>
	];
	
	
	function initialize() {
		map = new google.maps.Map(
		document.getElementById("trailMap"), {
			center: new google.maps.LatLng(56.462020, -2.970724),
			zoom: 18,
			mapTypeId: google.maps.MapTypeId.SATELLITE
		});
		geocoder = new google.maps.Geocoder();
		
		for (i = 0; i < locations.length; i++) {
			
			
			geocodeAddress(locations, i);
		}
		google.maps.event.addListener(map, 'click', function(event){
			this.setOptions({scrollwheel:true});
		});
		google.maps.event.addListener(map, 'mouseout', function(event){
			this.setOptions({scrollwheel:false});  
		});
	}
	google.maps.event.addDomListener(window, "load", initialize);
	
	function geocodeAddress(locations, i) {
		var title = locations[i][0];
		var address = locations[i][1];
		var url = locations[i][2];
		var icons = locations[i][3];
		geocoder.geocode({
			'address': locations[i][1]
		},
		function(results, status) {
			if (status == google.maps.GeocoderStatus.OK) {
				var marker = new google.maps.Marker({
					icon: icons,
					/* icon: '<?php if ( has_post_thumbnail() ) { $feat_image_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'small-pic')[0]; echo $feat_image_url; } else {} ?>', */
					/* icon: '', */
					map: map,
					position: results[0].geometry.location,
					title: title,
					animation: google.maps.Animation.DROP,
					address: address,
					url: url
				})
				infoWindow(marker, map, title, address, url);
				bounds.extend(marker.getPosition());
				map.fitBounds(bounds);
				} else if (status === google.maps.GeocoderStatus.OVER_QUERY_LIMIT) {
				setTimeout(function() {
				codeAddress(zip);
				}, 250 ); 
				} else {
				alert("geocode of " + address + " failed:" + status);
			}
		});
	}
	
	function infoWindow(marker, map, title, address, url) {
		google.maps.event.addListener(marker, 'click', function() {
			var html = "<div><h3>" + title + "</h3><p>" + address + "<br></div><a class='text-center map-btn' href='" + url + "' title='View the " + title + " sculpture'>View Sculpture</a></p></div>";
			iw = new google.maps.InfoWindow({
				content: html,
				maxWidth: 350
			});
			iw.open(map, marker);
		});
	}
	
	function createMarker(results) {
		var marker = new google.maps.Marker({
			icon: '<?php if ( has_post_thumbnail() ) { $feat_image_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'small-pic')[0]; echo $feat_image_url; } else {} ?>',
			/* icon: '', */
			map: map,
			position: results[0].geometry.location,
			title: title,
			animation: google.maps.Animation.DROP,
			address: address,
			url: url
		})
		bounds.extend(marker.getPosition());
		map.fitBounds(bounds);
		infoWindow(marker, map, title, address, url);
		return marker;
	}
	</script>
<?php } else { } ?>