<?php while (have_posts()) : the_post(); ?>
<div class="container-fluid sectionStrip singlePost">
	<div class="navigationPost hidden-md">
	<?php
		$prev_post = get_previous_post();
		if($prev_post) {
		?>
		<div class="nextPost">
			<?php
				$prev_title = strip_tags(str_replace('"', '', $prev_post->post_title));
				echo "\t" . '<a rel="prev" class="prev" href="' . get_permalink($prev_post->ID) . '" title="The ' . $prev_title. ' Sculpture" class=" "><i class="fa fa-angle-right" aria-hidden="true"></i></a>' . "\n";
			?>
		</div>
	<?php } ?>
	<?php 
		$next_post = get_next_post();
		if($next_post) {
		?>
		<div class="previousPost">
			<?php
				$next_title = strip_tags(str_replace('"', '', $next_post->post_title));
				echo "\t" . '<a rel="next" class="next" href="' . get_permalink($next_post->ID) . '" title="The ' . $next_title. ' Sculpture" class=" "><i class="fa fa-angle-left" aria-hidden="true"></i></a>' . "\n";
			?>
		</div>
	<?php } ?>
	</div>
	<div class="container">
		<div class="row">
			<div class="col-xs-12">
				<h1 class="scriptHead postTitle"><?php the_title();?></h1>
				<div class="postDetails">
					
					<article <?php post_class(); ?>>
						<div class="entry-content">
							<?php 
								$contento = get_the_content();
								if ( $contento != '' ) {
							?>
							<?php the_content(); ?>
							<?php } else {} ?>
						</div>
					</article>
					
					<div class="row hidden-sm hidden-md hidden-lg">
						<?php
							$prev_post = get_previous_post();
							if($prev_post) {
							?>
							<div class="col-xs-12 col-sm-6">
								<?php
									$prev_title = strip_tags(str_replace('"', '', $prev_post->post_title));
									echo "\t" . '<a rel="prev" class="bk2 prev" href="' . get_permalink($prev_post->ID) . '" title="The ' . $prev_title. ' Sculpture" class=" "><i class="fa fa-angle-left" aria-hidden="true"></i> Previous</a>' . "\n";
								?>
							</div>
						<?php } ?>
						<?php 
							$next_post = get_next_post();
							if($next_post) {
							?>
							<div class="col-xs-12 col-sm-6">
								<?php
									$next_title = strip_tags(str_replace('"', '', $next_post->post_title));
									echo "\t" . '<a rel="next" class="bk2 next" href="' . get_permalink($next_post->ID) . '" title="The ' . $next_title. ' Sculpture" class=" ">Next<i class="fa fa-angle-right" aria-hidden="true"></i></a>' . "\n";
								?>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="container-fluid mapStrip" id="findMe">
	<div id="whereamI">
	</div>
</div>
<script>
	if(jQuery('#whereamI').length > 0 ){	
		google.maps.event.addDomListener(window, 'load', init);
		var map;
		function init() {
		var mapOptions = {
		center: new google.maps.LatLng(<?php the_field('lat_long'); ?>),
		zoom: 14,
		zoomControl: true,
		zoomControlOptions: {
		style: google.maps.ZoomControlStyle.DEFAULT,
		},
		disableDoubleClickZoom: true,
		mapTypeControl: true,
		mapTypeControlOptions: {
		style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
		},
		scaleControl: true,
		scrollwheel: false,
		panControl: true,
		streetViewControl: true,
		draggable : true,
		overviewMapControl: true,
		overviewMapControlOptions: {
		opened: false,
		},
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		}
		var mapElement = document.getElementById('whereamI');
		var map = new google.maps.Map(mapElement, mapOptions);
		<?php if ( has_post_thumbnail() ) { 
		$feat_image_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'small-pic')[0]; 
		} else {
		
		} ?>
		var locations = [['<?php the_title();?>', 'undefined', 'undefined', 'undefined', 'undefined', <?php the_field('lat_long'); ?>, '<?php echo $feat_image_url; ?>']
		];
		for (i = 0; i < locations.length; i++) {
		if (locations[i][1] =='undefined'){ description ='';} else { description = locations[i][1];}
		if (locations[i][2] =='undefined'){ telephone ='';} else { telephone = locations[i][2];}
		if (locations[i][3] =='undefined'){ email ='';} else { email = locations[i][3];}
		if (locations[i][4] =='undefined'){ web ='';} else { web = locations[i][4];}
		if (locations[i][7] =='undefined'){ markericon ='';} else { markericon = locations[i][7];}
		marker = new google.maps.Marker({
		icon: markericon,
		position: new google.maps.LatLng(locations[i][5], locations[i][6]),
		map: map,
		title: locations[i][0],
		desc: description,
		tel: telephone,
		email: email,
		web: web
		});
		link = '';            
		bindInfoWindow(marker, map, locations[i][0], description, telephone, email, web, link);
		}
		function bindInfoWindow(marker, map, title, desc, telephone, email, web, link) {
		var infoWindowVisible = (function () {
		var currentlyVisible = false;
		return function (visible) {
		if (visible !== undefined) {
		currentlyVisible = visible;
		}
		return currentlyVisible;
		};
		}());
		iw = new google.maps.InfoWindow();
		google.maps.event.addListener(marker, 'click', function() {
		if (infoWindowVisible()) {
		iw.close();
		infoWindowVisible(false);
		} else {
		var html= "<div style='color:#000;background-color:#fff;padding:5px;width:150px;'><p class='text-center'>Scan me on the App when you find me!</p></div>";
		iw = new google.maps.InfoWindow({content:html});
		iw.open(map,marker);
		infoWindowVisible(true);
		}
		});
		google.maps.event.addListener(iw, 'closeclick', function () {
		infoWindowVisible(false);
		});
		}
		google.maps.event.addListener(map, 'click', function(event){
		this.setOptions({scrollwheel:true});
		});
		google.maps.event.addListener(map, 'mouseout', function(event){
		this.setOptions({scrollwheel:false});  
		});
		}
	};
</script>

<?php if (have_rows('my_story')) { ?>
	<?php 
		while (have_rows('my_story')) {
			the_row();
			if (get_sub_field('background_image')) {
				$bgPan = get_sub_field('background_image');
				$bgPan = $bgPan ? wp_get_attachment_image_src($bgPan, 'full') : array('http://dummyimage.com/2000x500/858585/fff.jpg&text=Image+Pending');
				$imageClasses = 'backgroundImages';
				$colourSplash = '<div class="coloursplash"></div>';
				} else {
				$imageClasses = '';
			}
		?>
		<div class="container-fluid sectionStrip aboutUs <?php echo $imageClasses; ?>" id="myStory" style="background-image: url(<?php echo $bgPan[0];?>)">
			<?php 
				
				echo $colourSplash; 
				
			?>
			<div class="container">
				<div class="row storyContent">
					<div class="col-xs-12">
						<?php the_sub_field('content'); ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>
<?php } ?>

<?php endwhile; ?>

<?php include(get_template_directory() . '/templates/featured-penguins.php'); ?>

<?php include(get_template_directory() . '/templates/sponsor-list.php'); ?>
