<?php while (have_posts()) : the_post(); ?>

	<div class="container">
		<div class="sectionStrip rowWrap text-center">
			<div class="row">
				<div class="col-xs-12">
					<h2 class="scriptHead">The School Penguins</h2>
				</div>
			</div>
		</div>
	</div>

	<div class="container-fluid sectionStrip singlePost singlepenguin">
		<div class="navigationPost hidden-md">
			<?php
			$prev_post = get_previous_post();
			if($prev_post) {
				?>
				<div class="next">
					<?php
					$prev_title = strip_tags(str_replace('"', '', $prev_post->post_title));
					echo "\t" . '<a rel="prev" class="prev" href="' . get_permalink($prev_post->ID) . '" title="The ' . $prev_title. ' Sculpture" class=" "><i class="fa fa-angle-right" aria-hidden="true"></i></a>' . "\n";
					?>
				</div>
			<?php } ?>
			<?php
			$next_post = get_next_post();
			if($next_post) {
				?>
				<div class="previous">
					<?php
					$next_title = strip_tags(str_replace('"', '', $next_post->post_title));
					echo "\t" . '<a rel="next" class="next" href="' . get_permalink($next_post->ID) . '" title="The ' . $next_title. ' Sculpture" class=" "><i class="fa fa-angle-left" aria-hidden="true"></i></a>' . "\n";
					?>
				</div>
			<?php } ?>
		</div>

		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<h1><?php the_title(); ?></h1>
					<div class="inner-content">
						<div class="row">
							<div class="col-md-7">
								<h4><strong><?php the_field('group_label'); ?>:</strong>
									<?php if (get_field('group_website')) { echo '<a href="'.get_field('group_website').'" title="Learn more about this Group" target="_blank">'; }; ?>
									<?php the_field('group'); ?>
									<?php if (get_field('group_website')) { echo '</a>'; } ?>
								</h4>
								<?php if(get_field('sponsored_text')){ ?>
									<h4><strong>Created By:</strong>
										<?php the_field('sponsored_text'); ?>
									</h4>
								<?php } ?>

								<?php the_field('artist_bio'); ?>
								<?php the_content(); ?>


								<div class="row">
									<div class="col-xs-12 col-sm-4">
										<a class="bk2" href="#findMe">Where Am I</a>
									</div>
									<div class="col-xs-12 col-sm-4">
										<a class="bk2 blue" href="#myFriends">My Friends</a>
									</div>
									<div class="col-xs-12 col-sm-4">
										<a class="bk2 pink paradePDFDownload" title="Download The Penguin Parade Map" target="_blank" href="<?php the_field('trail_map','options'); ?>">Parade Map</a>
									</div>
								</div>

								<div class="row">
									<div class="col-xs-12 col-lg-6 col-lg-offset-3">
										<p class="text-center text-uppercase"><strong><?php the_field('sponsored_text'); ?></strong></p>
									</div>
									<div class="img-ctn">
										<img src="<?php the_field('sponsored_by_image'); ?>">
									</div>


								</div>
							</div>


							<div class="col-md-5">
								<?php if ( has_post_thumbnail() ) {
									echo get_the_post_thumbnail(get_the_ID(), 'full', array('class' => 'img-responsive center-block penguin-pic'));
								} else { ?>
									<img src="<?php the_field('default_penguin_image','option'); ?>" alt="penguin" class="img-responsive center-block" />
								<?php } ?>

								<!-- I Sold For -->
								<?php if (get_field('sold_for')){ ?>
									<div class="row">
										<div class="col-xs-12 text-center">
											<div class="singleSale" style="margin: 40px auto 40px;">
												<p>I SOLD FOR</p>
												<p class="scriptHead sectionHeader">£<?php the_field('sold_for'); ?></p>
											</div>
										</div>
									</div>
								<?php } ?>
								<!-- I Sold For -->
							</div>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.js"></script>
    <?php
        $tags = get_the_tags();
        if (!empty($tags)) {
            $args = array(
                'posts_per_page' => -1,
                'post_type' => 'schoolpenguins',
                'tag' => $tags[0]->slug
            );
            $query = new WP_Query($args);
        }
        else {
            $query = null;
        }
    ?>

	<div class="container-fluid mapStrip" id="findMe">
        <?php $location = get_field('lat_long'); ?>
        <?php $thisId = get_the_ID(); ?>
        <div id="whereamI" class="school-map">
        <div class="marker" data-lat="<?=$location['lat']?>" data-lng="<?=$location['lng']?>" data-icon="<?=wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'small-pic')[0];?>"></div>
        <?php if($query !== null && $query->have_posts()) : ?>
            <?php while($query->have_posts()) : ?>
                <?php $query->the_post(); ?>
                <?php if($thisId != get_the_ID()) : ?>
                    <?php $loc = get_field('lat_long'); ?>
                    <div class="marker" data-lat="<?=$loc['lat']?>" data-lng="<?=$loc['lng']?>" data-icon="<?=wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'small-pic')[0];?>"></div>
                <?php endif; ?>
            <?php endwhile; ?>
        <?php endif; ?>
		</div>
    </div>


	<?php if (have_rows('my_story')) { ?>
		<?php
		while (have_rows('my_story')) {
			the_row();
			if (get_sub_field('background_image')) {
				$bgPan = get_sub_field('background_image');
				$bgPan = $bgPan ? wp_get_attachment_image_src($bgPan, 'full') : array('http://dummyimage.com/2000x500/858585/fff.jpg&text=Image+Pending');
				$imageClasses = 'backgroundImages';
				$colourSplash = '<div class="coloursplash"></div>';
			} else {
				$imageClasses = '';
			}
			?>
			<div class="container-fluid sectionStrip aboutUs <?php echo $imageClasses; ?>" id="myStory" style="background-image: url(<?php echo $bgPan[0];?>)">
				<?php

				echo $colourSplash;

				?>
				<div class="container">
					<div class="row storyContent">
						<div class="col-xs-12">
							<?php the_sub_field('content'); ?>
						</div>
					</div>
				</div>
			</div>
		<?php } ?>
	<?php } ?>

<?php endwhile; ?>

<?php include(get_template_directory() . '/templates/featured-penguins.php'); ?>

<?php include(get_template_directory() . '/templates/sponsor-list.php'); ?>
