<?php while (have_posts()) : the_post(); ?>

	<div class="container">
		<div class="sectionStrip rowWrap text-center">
			<div class="row">
				<div class="col-xs-12">
					<h2 class="scriptHead">The Penguins</h2>
				</div>
			</div>
		</div>
	</div>

	<div class="container-fluid sectionStrip singlePost singlepenguin">
		<div class="navigationPost hidden-md">
			<?php
			$prev_post = get_previous_post();
			if($prev_post) {
				?>
				<div class="next">
					<?php
					$prev_title = strip_tags(str_replace('"', '', $prev_post->post_title));
					echo "\t" . '<a rel="prev" class="prev" href="' . get_permalink($prev_post->ID) . '" title="The ' . $prev_title. ' Sculpture" class=" "><i class="fa fa-angle-right" aria-hidden="true"></i></a>' . "\n";
					?>
				</div>
			<?php } ?>
			<?php
			$next_post = get_next_post();
			if($next_post) {
				?>
				<div class="previous">
					<?php
					$next_title = strip_tags(str_replace('"', '', $next_post->post_title));
					echo "\t" . '<a rel="next" class="next" href="' . get_permalink($next_post->ID) . '" title="The ' . $next_title. ' Sculpture" class=" "><i class="fa fa-angle-left" aria-hidden="true"></i></a>' . "\n";
					?>
				</div>
			<?php } ?>
		</div>

		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<h1><?php the_title(); ?></h1>
					<div class="inner-content">
						<div class="row">
							<div class="col-md-7">
								<h4><strong>Artists Name:</strong>
									<?php if (get_field('artist_website')) { echo '<a href="'.get_field('artist_website').'" title="Learn more about this Artist" target="_blank">'; }; ?>
									<?php the_field('artist'); ?>
									<?php if (get_field('artist_website')) { echo '</a>'; } ?>
								</h4>
                                <?php $posts = get_field('sponsored_by'); ?>
                                <?php if( $posts ): ?>
                                <h4><strong>Sponsored By:</strong>
                                <?php foreach($posts as $p) : ?>
                                    <?=$p->post_title ?>
                                <?php endforeach; ?>
                                </h4>
                                <?php endif; ?>

								<?php the_field('artist_bio'); ?>
								<?php the_content(); ?>


								<div class="row">
									<div class="col-xs-12 col-sm-4">
										<a class="bk2" href="#findMe">Where Am I</a>
									</div>
									<div class="col-xs-12 col-sm-4">
										<a class="bk2 blue" href="#myFriends">My Friends</a>
									</div>
									<div class="col-xs-12 col-sm-4">
										<a class="bk2 pink paradePDFDownload" title="Download The Penguin Parade Map" target="_blank" href="<?php the_field('trail_map','options'); ?>">Parade Map</a>
									</div>
								</div>

								<div class="row">
									<?php $posts = get_field('sponsored_by'); ?>
									<?php if( $posts ): ?>
										<?php $count = 0; ?>
										<div class="col-xs-12 col-lg-6 col-lg-offset-3">
											<p class="text-center text-uppercase"><strong>Sponsored By</strong></p>
										</div>
										<?php foreach( $posts as $p ):?><!-- Get Count -->
											<?php $count++;
											if ($count >= 3) {
												$classes ="col-xs-12 col-md-4";
											} else if ($count >= 2) {
												$classes ="col-xs-12 col-md-6";
											} else {
												$classes ="col-xs-12 col-lg-6 col-lg-offset-3";
											} ?>
										<?php endforeach; ?>
										<?php foreach( $posts as $p ):?>
											<div class="<?php echo $classes;?>">
												<a href="<?php the_field('url', $p->ID); ?>" class="img-responsive sponsor center-block" target="_blank" title="Visit this Sponsors website">
													<?php
													if ( has_post_thumbnail() ) {
														echo get_the_post_thumbnail($p->ID, 'full', array('class' => 'img-responsive center-block', 'alt' => ''.get_the_title().''));
													} else { }
													?>
												</a>
												<?php
												if ($count >= 3) {
													if (get_field('bio', $p->ID)) { the_field('bio', $p->ID); }
												} else if ($count >= 2) {
													if (get_field('bio', $p->ID)) { the_field('bio', $p->ID); }
												} else {
													echo '</div>';
													echo '<div class="col-xs-12">';
													if (get_field('bio', $p->ID)) { the_field('bio', $p->ID); }
//													echo '</div>';
												}
												?>
											</div>
										<?php endforeach; ?>
									<?php endif; ?>
								</div>
							</div>


							<div class="col-md-5">
								<?php if ( has_post_thumbnail() ) {
									echo get_the_post_thumbnail(get_the_ID(), 'full', array('class' => 'img-responsive center-block penguin-pic'));
								} else { ?>
									<img src="<?php the_field('default_penguin_image','option'); ?>" alt="penguin" class="img-responsive center-block" />
								<?php } ?>

								<!-- I Sold For -->
								<?php if (get_field('sold_for')){ ?>
									<div class="row">
										<div class="col-xs-12 text-center">
											<div class="singleSale" style="margin: 40px auto 40px;">
												<p>I SOLD FOR</p>
												<p class="scriptHead sectionHeader">£<?php the_field('sold_for'); ?></p>
											</div>
										</div>
									</div>
								<?php } ?>
								<!-- I Sold For -->
							</div>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.js"></script>

	<div class="container-fluid mapStrip" id="findMe">
		<div id="whereamI">
		</div>
	</div>
	<script>
        <?php $location = get_field('lat_long'); ?>
		if(jQuery('#whereamI').length > 0 ){
			google.maps.event.addDomListener(window, 'load', init);
			var map;
			function init() {
				var mapOptions = {
					center: new google.maps.LatLng(<?=$location['lat']?>, <?=$location['lng']?>),
					zoom: 14,
					zoomControl: true,
					zoomControlOptions: {
						style: google.maps.ZoomControlStyle.DEFAULT,
					},
					disableDoubleClickZoom: true,
					mapTypeControl: true,
					mapTypeControlOptions: {
						style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
					},
					scaleControl: true,
					scrollwheel: false,
					panControl: true,
					streetViewControl: true,
					draggable : true,
					overviewMapControl: true,
					overviewMapControlOptions: {
						opened: false,
					},
					mapTypeId: google.maps.MapTypeId.ROADMAP,
				}
				var mapElement = document.getElementById('whereamI');
				var map = new google.maps.Map(mapElement, mapOptions);
				<?php if ( has_post_thumbnail() ) {
				$feat_image_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'small-pic')[0];
			} else {

			} ?>
				var locations = [['<?php the_title();?>', 'undefined', 'undefined', 'undefined', 'undefined', <?=$location['lat']?>, <?=$location['lng']?>, '<?php echo $feat_image_url; ?>']
				];
				for (i = 0; i < locations.length; i++) {
					if (locations[i][1] =='undefined'){ description ='';} else { description = locations[i][1];}
					if (locations[i][2] =='undefined'){ telephone ='';} else { telephone = locations[i][2];}
					if (locations[i][3] =='undefined'){ email ='';} else { email = locations[i][3];}
					if (locations[i][4] =='undefined'){ web ='';} else { web = locations[i][4];}
					if (locations[i][7] =='undefined'){ markericon ='';} else { markericon = locations[i][7];}
					marker = new google.maps.Marker({
						icon: markericon,
						position: new google.maps.LatLng(locations[i][5], locations[i][6]),
						map: map,
						title: locations[i][0],
						desc: description,
						tel: telephone,
						email: email,
						web: web
					});
					link = '';
					bindInfoWindow(marker, map, locations[i][0], description, telephone, email, web, link);
				}
				function bindInfoWindow(marker, map, title, desc, telephone, email, web, link) {
					var infoWindowVisible = (function () {
						var currentlyVisible = false;
						return function (visible) {
							if (visible !== undefined) {
								currentlyVisible = visible;
							}
							return currentlyVisible;
						};
					}());
					iw = new google.maps.InfoWindow();
					google.maps.event.addListener(marker, 'click', function() {
						if (infoWindowVisible()) {
							iw.close();
							infoWindowVisible(false);
						} else {
							var html= "<div style='color:#000;background-color:#fff;padding:5px;width:150px;'><p class='text-center'>Scan me on the App when you find me!</p></div>";
							iw = new google.maps.InfoWindow({content:html});
							iw.open(map,marker);
							infoWindowVisible(true);
						}
					});
					google.maps.event.addListener(iw, 'closeclick', function () {
						infoWindowVisible(false);
					});
				}
				google.maps.event.addListener(map, 'click', function(event){
					this.setOptions({scrollwheel:true});
				});
				google.maps.event.addListener(map, 'mouseout', function(event){
					this.setOptions({scrollwheel:false});
				});
			}
		};
	</script>

	<?php if (have_rows('my_story')) { ?>
		<?php
		while (have_rows('my_story')) {
			the_row();
			if (get_sub_field('background_image')) {
				$bgPan = get_sub_field('background_image');
				$bgPan = $bgPan ? wp_get_attachment_image_src($bgPan, 'full') : array('http://dummyimage.com/2000x500/858585/fff.jpg&text=Image+Pending');
				$imageClasses = 'backgroundImages';
				$colourSplash = '<div class="coloursplash"></div>';
			} else {
				$imageClasses = '';
			}
			?>
			<div class="container-fluid sectionStrip aboutUs <?php echo $imageClasses; ?>" id="myStory" style="background-image: url(<?php echo $bgPan[0];?>)">
				<?php

				echo $colourSplash;

				?>
				<div class="container">
					<div class="row storyContent">
						<div class="col-xs-12">
							<?php the_sub_field('content'); ?>
						</div>
					</div>
				</div>
			</div>
		<?php } ?>
	<?php } ?>

<?php endwhile; ?>

<?php include(get_template_directory() . '/templates/featured-penguins.php'); ?>

<?php include(get_template_directory() . '/templates/sponsor-list.php'); ?>
