<?php
	/**
		Template Name: School Penguins
	**/
?>
<div class="container-fluid sectionStrip rowWrap text-center">
	<div class="row">
		<div class="col-xs-12">
			<h1 class="scriptHead">The School Penguins</h1>
			<h2></h2>
		</div>
	</div>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 buttnzBox">
				<div class="row">
					<div class="col-xs-12 col-sm-4">
						<a href="/penguin/" class="mediaBtns green">All Penguins</a>
					</div>
					<div class="col-xs-12 col-sm-4">
						<a href="/tour-penguins/" class="mediaBtns blue">Tour Penguins</a>
					</div>
					<div class="col-xs-12 col-sm-4">
						<a href="/school-penguins" class="mediaBtns pink">School Penguins</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="container-fluid sectionStrip resources">
	<div class="container">
		<div class="row rowContainer">
			<?php $posts = get_field('tour_penguins'); ?>
			<?php if( $posts ): ?>
			<?php foreach( $posts as $p ): ?>
				<?php if (get_field('teaser_picture')) { ?>
					<?php $schoolpenguins = get_field('teaser_picture', $p->ID); ?>
					<?php $feat_image_url1 = $schoolpenguins['url']; ?>
					<?php } else { ?>
					<?php 
						if ( has_post_thumbnail() ) { $feat_image_url1 = wp_get_attachment_image_src(get_post_thumbnail_id($p->ID), 'teaser-pic')[0]; } else { $feat_image_url1 = ''; }
					?>				
				<?php } ?>
				<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 resourcePan" style="background-image: url(<?php echo $feat_image_url1; ?>)">
					<div class="coloursplash"></div>
					<div class="resInt text-center">
						<p><?php echo get_the_title( $p->ID ); ?></p>
						<p>By <?php the_field('artist', $p->ID); ?></p>
						<a href="<?php echo get_permalink( $p->ID ); ?>" class="dwnload">View</a>
					</div>
				</div>
			<?php endforeach; ?> 
			<?php endif; ?>
		</div>
	</div>
</div>

<?php include(get_template_directory() . '/templates/sponsor-list.php'); ?>