<?php
	/**
	 * Template Name: App Template
 	*/
?>
	<div class="container">
		<div class=" sectionStrip rowWrap text-center">
			<div class="row">
				<div class="col-xs-12">
					<h1 class="scriptHead"><?php the_field('above_panels_text'); ?></h1>
				</div>
			</div>
		</div>
	</div>

	<?php $stripImage = get_field('strip_image'); ?>
	<div class="aboutUs" style="background-image: url(<?php the_post_thumbnail_url(); ?>); background-attachment:fixed ">
		<div class="container">
			<div class="panels">
				<?php
					if( have_rows('panel') ){
						$i = 1;
						while ( have_rows('panel') ) : the_row(); ?>
							<div class="row">
								<div class="panel-inner">
									<div class="col-md-6">
										<?php
											$fontsize = '';
											if(get_sub_field('custom_size') == 'Yes') {
												$fontsize = get_sub_field('font_size');
											}
										?>
										<h2 style="font-size:<?php echo $fontsize; ?>px; margin-top:<?php the_sub_field('top_spacing'); ?>px;"><?php the_sub_field('title'); ?></h2>
										<?php if(get_sub_field('sub_title')){ ?>
											<h3><?php the_sub_field('sub_title'); ?></h3>
										<?php } ?>
										<?php the_sub_field('text'); ?>
										<?php if(get_sub_field('show_app_store_buttons') == 'Yes'){ ?>
											<div class="ctas">
												<div class="row">
													<div class="col-md-4 btn-first">
														<a href="<?php the_field('apple_link'); ?>" target="_blank">
															<img src="<?php the_field('apple_image'); ?>">
														</a>
													</div>
													<div class="col-md-4">
														<a href="<?php the_field('android_link'); ?>" target="_blank">
															<img src="<?php the_field('android_image'); ?>">
														</a>
													</div>
												</div>
											</div>
										<?php } ?>
									</div>
									<div class="col-md-6">
										<img src="<?php the_sub_field('image'); ?>" class="app-img">
									</div>
								</div>
							</div>
						<?php $i++; endwhile;
					}
				?>
			</div>

			<div class="row">
				<div class="faqs">
					<?php
					if( have_rows('faq') ){
						$i = 1;

						if(get_field('faq_title')){ ?>
							<h2 id="title"><?php the_field('faq_title') ?></h2>
						<?php } ?>

						<div class="panel-group" id="accordion">
							<?php while ( have_rows('faq') ) : the_row(); ?>
								<div class="panel panel-default">
									<div class="panel-heading">
										<h4 class="panel-title">
											<a data-toggle="collapse" data-parent="#accordion" href="#collapse<?php echo $i; ?>"><?php the_sub_field('question'); ?></a>
										</h4>
									</div>
									<div id="collapse<?php echo $i; ?>" class="panel-collapse collapse <?php if($i == 1){ echo 'in'; } ?>">
										<div class="panel-body">
											<?php the_sub_field('answer'); ?>
										</div>
									</div>
								</div>
							<?php $i++; endwhile; ?>
						</div>
					<?php }
					?>
				</div>
			</div>
		</div>
	</div>

<div class="banner-section">
	<div class="row">
		<div class="col-md-6 col-md-offset-3">
			<?php the_field('banner_text') ?>
			<div class="row">
				<div class="col-md-3 col-md-offset-3">
					<a href="<?php the_field('apple_link'); ?>" target="_blank">
						<img src="<?php the_field('apple_image'); ?>">
					</a>
				</div>
				<div class="col-md-3">
					<a href="<?php the_field('android_link'); ?>" target="_blank">
						<img src="<?php the_field('android_image'); ?>">
					</a>
				</div>
			</div>
		</div>
	</div>
</div>


<!--<div id="sponsor-ctn">-->
<!--	--><?php //include(get_template_directory() . '/templates/sponsor-list.php'); ?>
<!--</div>-->
