/* ========================================================================
 * DOM-based Routing
 * Based on http://goo.gl/EUTi53 by Paul Irish
 *
 * Only fires on body classes that match. If a body class contains a dash,
 * replace the dash with an underscore when adding it to the object below.
 *
 * .noConflict()
 * The routing is enclosed within an anonymous function so that you can
 * always reference jQuery with $, even when in .noConflict() mode.
 * ======================================================================== */

(function($) {

    // Use this variable to set up the common and page specific functions. If you
    // rename this variable, you will also need to rename the namespace below.
    var Sage = {
        // All pages
        'common': {
            init: function() {
                // JavaScript to be fired on all pages
            },
            finalize: function() {
                function add_marker($marker, map) {
                    var latlng = new google.maps.LatLng($marker.attr('data-lat'), $marker.attr('data-lng'));
                    var icon = $marker.attr('data-icon');
                    // create marker
                    var marker = new google.maps.Marker({
                        position: latlng,
                        map: map,
                        icon: icon
                    });
                    // add to array
                    map.markers.push(marker);
                    // if marker contains HTML, add it to an infoWindow
                    if ($marker.html()) {
                        // create info window
                        var infowindow = new google.maps.InfoWindow({
                            content: $marker.html()
                        });
                        // show info window when marker is clicked
                        google.maps.event.addListener(marker, 'click', function() {
                            infowindow.open(map, marker);
                        });
                    }
                }

                function center_map(map) {
                    var bounds = new google.maps.LatLngBounds();
                    $.each(map.markers, function(i, marker) {
                        var latlng = new google.maps.LatLng(marker.position.lat(), marker.position.lng());
                        bounds.extend(latlng);
                    });
                    // only 1 marker?
                    if (map.markers.length === 1) {
                        // set center of map
                        map.setCenter(bounds.getCenter());
                        map.setZoom(16);
                    } else {
                        // fit to bounds
                        map.fitBounds(bounds);
                    }
                }

                function new_map($el) {
                    var $markers = $el.find('.marker');
                    var args = {
                        zoom: 16,
                        center: new google.maps.LatLng(0, 0),
                        mapTypeId: google.maps.MapTypeId.ROADMAP
                    };
                    var map = new google.maps.Map($el[0], args);
                    map.markers = [];
                    $markers.each(function() {
                        add_marker($(this), map);
                    });
                    center_map(map);
                    return map;
                }

                var map = null;

                $('.school-map').each(function() {
                    // create map
                    map = new_map($(this));
                });
            }
        },
        // Home page
        'home': {
            init: function() {
                // JavaScript to be fired on the home page
            },
            finalize: function() {
                // JavaScript to be fired on the home page, after the init JS
            }
        },
        // About us page, note the change from about-us to about_us.
        'about_us': {
            init: function() {
                // JavaScript to be fired on the about us page
            }
        }
    };

    // The routing fires all common scripts, followed by the page specific scripts.
    // Add additional events for more control over timing e.g. a finalize event
    var UTIL = {
        fire: function(func, funcname, args) {
            var fire;
            var namespace = Sage;
            funcname = (funcname === undefined) ? 'init' : funcname;
            fire = func !== '';
            fire = fire && namespace[func];
            fire = fire && typeof namespace[func][funcname] === 'function';

            if (fire) {
                namespace[func][funcname](args);
            }
        },
        loadEvents: function() {
            // Fire common init JS
            UTIL.fire('common');

            // Fire page-specific init JS, and then finalize JS
            $.each(document.body.className.replace(/-/g, '_').split(/\s+/), function(i, classnm) {
                UTIL.fire(classnm);
                UTIL.fire(classnm, 'finalize');
            });

            // Fire common finalize JS
            UTIL.fire('common', 'finalize');
        }
    };

    /* Custom Scripts */
    /* */
    $('#burgerNavBtn').click(function() {
        $(this).toggleClass('open');
        $('.nav-primary').toggleClass("expand");
        $('header').toggleClass("openNav");
    });

    $("#tubular-container").after($("header"));

    $(".theBucketTrail").after($(".tubularWrapper"));

    // store the slider in a local variable
    var $window = $(window),
        flexslider;

    // tiny helper function to add breakpoints
    function getGridSize() {
        return (window.innerWidth < 600) ? 2 :
            (window.innerWidth < 900) ? 2 : 6;
    }


    $('.flexslider').flexslider({
        slideshow: true,
        slideshowSpeed: 5000,
        pauseOnAction: true,
        pauseOnHover: true,
        animation: "slide",
        animationLoop: true,
        directionNav: true,
        controlNav: false,
        itemWidth: 210,
        itemMargin: 5,
        minItems: getGridSize(),
        maxItems: getGridSize(),
        touch: true,
        useCSS: false
    });


    $window.resize(function() {
        var gridSize = getGridSize();
        flexslider.vars.minItems = gridSize;
        flexslider.vars.maxItems = gridSize;
    });

    $('a.dropdown-toggle').click(function() {
        if ($(this).parent().hasClass('open')) {
            window.location.href = $(this).attr('href');
        }
    });

    if ($(window).width() < 991) {
        $('li.menu-item-has-children a').click(function() {
            if ($(this).parent().hasClass('open')) {
                window.location.href = $(this).attr('href');
            }
        });
    }

    // Scroll to anchor tags smoothly
    $(function() {



        $('a[href*="#"]:not([href="#"])').click(function() {
            if(!$(this).parent().hasClass('panel-title')){
                if (location.pathname.replace(/^\//, '') === this.pathname.replace(/^\//, '') && location.hostname === this.hostname) {
                    var target = $(this.hash);
                    target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
                    if (target.length) {
                        $('html, body').animate({
                            scrollTop: target.offset().top
                        }, 1000);
                        return false;
                    }
                }
            }
        });


    });

    $(document).ready(UTIL.loadEvents);

})(jQuery); // Fully reference jQuery after this point.