<?php
/**
 * The Template for displaying products in a product tag. Simply includes the archive template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/taxonomy-product_tag.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @package    WooCommerce/Templates
 * @version     1.6.4
 */

/** This is the main template for collections **/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

get_header('shop');

/**
 * ALTERED HOOK
 * woocommerce_before_main_content hook.
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content');

global $wp_query;

$cat = $wp_query->get_queried_object();

$title = $cat->name;
$description = $cat->description;

$banner_id = get_woocommerce_term_meta($cat->term_id, 'thumbnail_id', true);

$bannerImage = get_field('banner_image', $cat->taxonomy . '_' . $cat->term_id);
$bannerImage = wp_get_attachment_url($bannerImage);
$tartanColour = strtolower(get_field('global_offset_tartan_colour')) . '-tartan';

$globalOffsetLink = get_field("global_offset_link", $cat);

$superTitle = get_field("super_title", $cat->taxonomy . '_' . $cat->term_id) ?? "";

?>
<div class="product-page product-collection">
    <section class="feature offset-section" style="background-image: url('<?= $bannerImage; ?>')">
        <div class="wrap-large">
            <?php
            $featuredImage = get_term_meta($cat->term_id, 'thumbnail_id', true);
            $featuredImage = wp_get_attachment_url($featuredImage);

            $title = $cat->name;
            $content = $cat->description;

            ?>
            <div class="offset-feature " style="background-image:url('<?= $featuredImage; ?>')">
                <div class="featured-image d-md-none">
                    <img src="<?= $featuredImage; ?>" alt=""/>
                </div>
                <div class="content-wrap <?= $tartanColour; ?>">
                    <?php
                    if ($superTitle !== "") {
                    ?>
                        <h2><?= $superTitle; ?></h2>
                    <?php
                    }
                    ?>
                    <h1><?= $title; ?></h1>
                    <p><?= $content; ?></p>
                    <?php if ($globalOffsetLink) { ?>
                        <a class="btn btn-primary" href="<?= $globalOffsetLink['url']; ?>"
                           target="<?= $globalOffsetLink['target']; ?>"><?= $globalOffsetLink['title'] ?></a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
    <?php get_template_part('woocommerce/parts/filter'); ?>
    <section class="product-list">
        <div class="wrap-large">
            <div class="row ">
                <?php
                $children = get_terms('product_cat',
                    ['parent' => $cat->term_id]
                );

                if (!$children) {
                    $args = [
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => -1,
                        'tax_query' => [
                            [
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => [$cat->term_id],
                            ],
                        ],
                    ];
                    $catQuery = new \WP_Query($args);

                    if ($catQuery->have_posts()) {
                        while ($catQuery->have_posts()) {
                            $catQuery->the_post();
                            do_action('woocommerce_shop_loop');
                            wc_get_template_part('content', 'product');
                        }
                    } else if (!woocommerce_product_subcategories(['before' => woocommerce_product_loop_start(false), 'after' => woocommerce_product_loop_end(false)])) {
                        /**
                         * woocommerce_no_products_found hook.
                         *
                         * @hooked wc_no_products_found - 10
                         */
                        do_action('woocommerce_no_products_found');
                    }
                    wp_reset_query();
                }

                foreach ($children as $child) { ?>
                    <h1 id="<?= $child->slug; ?>" class="col-md-12"><?= $child->name; ?></h1>
                    <?php $args = [
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => 50,
                        'orderby'        => 'menu_order',
                        'order' => 'asc',
                        'tax_query' => [
                            [
                                'taxonomy' => $child->taxonomy,
                                'field' => 'term_id',
                                'terms' => [$child->term_id],
                            ],
                        ],
                    ];

                    $catQuery = new \WP_Query($args);
                    if ($catQuery->have_posts()) {
                        while ($catQuery->have_posts()) {
                            $catQuery->the_post();
                            do_action('woocommerce_shop_loop');
                            wc_get_template_part('content', 'product');
                        }
                    } else if (!woocommerce_product_subcategories(['before' => woocommerce_product_loop_start(false), 'after' => woocommerce_product_loop_end(false)])) {
                        /**
                         * woocommerce_no_products_found hook.
                         *
                         * @hooked wc_no_products_found - 10
                         */
                        do_action('woocommerce_no_products_found');
                    }
                }
                wp_reset_query();
                ?>
            </div>
        </div>
    </section>
</div>
<?php get_footer('shop'); ?>
