<?php
global $post;

if (have_rows('featured_block')) {
    while (have_rows('featured_block')) {
        the_row();
        $backgroundImage = get_sub_field('background_image');
        $backgroundImage = wp_get_attachment_image_url($backgroundImage, 'banner');

        $title = get_sub_field('title');
        $subTitle = get_sub_field('sub_title');
        $content = get_sub_field('content');
        $link = get_sub_field('page_link');

        $featuredImage = get_sub_field('featured_image');
        $featuredImage = wp_get_attachment_image_url($featuredImage, 'full');

        $tartanColour = strtolower(get_sub_field('tartan_colour')) . '-tartan';

        if ($featuredImage) {
            
            ?>
            <section class="offset-section container" style="background-image:url('<?= $backgroundImage; ?>')">
                <div class="offset-feature wrap-large" style="background-image:url('<?= $featuredImage; ?>')">
                    <div class="featured-image d-md-none">
                        <img src="<?= $featuredImage; ?>" alt=""/>
                    </div>
                    <div class="content-wrap <?= $tartanColour; ?>">
                        <span class="supertitle"><?= $title; ?></span>
                        <h1><?= $subTitle; ?></h1>
                        <p><?= $content; ?></p>
                        <a class="btn btn-primary" href="<?= $link['url']; ?>"
                           target="<?= $link['target']; ?>"><?= $link['title'] ?> <i class="far fa-arrow-right"></i></a>
                    </div>
                </div>
            </section>
            <?php
        } else {
            $terms = get_the_terms($post->ID, 'product_cat');
            $backgroundImage = get_field('global_offset_banner', 'product_cat_' . $terms[0]->term_id);
            $backgroundImage = wp_get_attachment_image_url($backgroundImage, 'banner');


            $title = get_field('global_offset_title', 'product_cat_' . $terms[0]->term_id);
            $content = get_field('global_offset_content', 'product_cat_' . $terms[0]->term_id);
            $link = get_field('global_offset_link', 'product_cat_' . $terms[0]->term_id);

            $featuredImage = get_field('global_offset_image', 'product_cat_' . $terms[0]->term_id);
            $featuredImage = wp_get_attachment_image_url($featuredImage, 'full');

            $tartanColour = strtolower(get_field('global_offset_tartan_colour', 'product_cat_' . $terms[0]->term_id)) . '-tartan';

            if ($featuredImage) {
                ?>
                <section class="offset-section container" style="background-image:url('<?= $backgroundImage; ?>')">
                    <div class="offset-feature wrap-large" style="background-image:url('<?= $featuredImage; ?>')">
                        <div class="featured-image d-md-none">
                            <img src="<?= $featuredImage; ?>" alt=""/>
                        </div>
                        <div class="content-wrap <?= $tartanColour; ?>">
                            <span class="supertitle"><?= $title; ?></span>
                            <h1><?= $subTitle; ?></h1>
                            <p><?= $content; ?></p>
                            <?php if ($link) { ?>
                                <a class="btn btn-primary" href="<?= $link['url']; ?>"
                                   target="<?= $link['target']; ?>"><?= $link['title'] ?> <i
                                            class="far fa-arrow-right"></i></a>
                            <?php } ?>
                        </div>
                    </div>
                </section>
                <?php
            }
        }
    }
}
