<section class="pillars pillars--front-page wrap-large">
    <div class="row">
        <div class="col-md-6 pillar-title"><?= get_sub_field('title'); ?></div>
        <div class="col-md-6 pillar-content"><?= get_sub_field('content'); ?></div>
    </div>
    <div class="pillars__content d-flex flex-wrap text-center">
        <?php while (have_rows('pillar')) {
            the_row();
            $pillar_img = get_sub_field('image');
            $fullwidth = get_sub_field('full_width');
            $colClass = $fullwidth ? ' col-12 pillar--fullwidth' : ' col-md-6 col-lg-3';
            $titleClass = '';
            $link_settings = get_sub_field('link_settings');
            if ($link_settings) {
                $pillar_link = $link_settings['link'];
                $hide_link_text = $link_settings['hide_link_text'];
                if ($hide_link_text == 1) {
                    $titleClass = " invisible";
                }
            }

            $pillar_video = get_sub_field('video_background');

            if ($pillar_video) {
                $videoID = $pillar_video['vimeo'];
                $overscan = $pillar_video['add_overscan'];
                $autoplay = $pillar_video['autoplay'];
                $videoAspect = $pillar_video['video_aspect'];
                if ($overscan == 1) {
                    $overscan = ' full-screen-bg__video--overscan';
                } else {
                    $overscan = '';
                }
                $hideControls = $pillar_video['hide_default_controls'];

            }
            if ($videoID) {
                $setAspect = " video-panel";
            } else {
                $setAspect = '';
            }

            ?>
            <div class="pillar<?= $colClass . $setAspect; ?>" <?= Blue2\Scruffy\Site::AOS_CLASSES[get_row_index() % 2]; ?>
                 data-aos-anchor-placement="top-bottom" data-aos-once="false" data-aos-duration="1000">
                <div class="pillar-hover-container">
                    <div class="pillar__inner"
                         style="<?php echo "background-image: url(" . $pillar_img['url'] . ");"; ?>">
                        <?php if ($videoID) {
                            ?>
                            <iframe class="full-screen-bg__video <?= $overscan ?>" id="backgroundVideo"
                                    src="https://player.vimeo.com/video/<?= $videoID; ?>?muted=<?= $autoplay ?>&autoplay=<?= $autoplay ?>&amp;api=1&amp;player_id=backgroundVideo&amp;background=<?= $hideControls; ?>&loop=1"
                                    frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen
                                    data-ready="true"></iframe>
                            <?php
                        }
                        ?>
                        <?php if ($pillar_link) {
                            ?>
                            <a href='<?= $pillar_link['url'] ?>' <?php if ($pillar_link['target']) {
                                echo 'target="' . $pillar_link['target'] . '"';
                            } ?> class="<?= $titleClass ?>Psuedo"></a>
                            <?php
                        }
                        ?>
                        <?php if ($videoID) { ?>
                            <div class="<?= $videoAspect; ?>"></div>
                            <?php
                        }
                        ?>
                    </div>
                    <span class='title<?= $titleClass ?>'><?= $pillar_link['title'] ?> </span>
                </div>

            </div>
        <?php } ?>
    </div>
</section>
