<?php
$location = get_field('location');
if ($location !== false) {
    $address = explode(', ', $location['address']);
}
$email = get_field('email_address');
$telephone = get_field('telephone_number');
$url = get_field('website_url');
$AllowOutfitBuilder = get_field('allow_outfit_builder_emails') ?? false;
?>

<article id="stockist-<?= get_the_id(); ?>">
    <h2><?php
        $title = strtolower(get_the_title());
        echo ucwords($title);
        ?>
    </h2>
    <div class="contact">
        <div class="contact__address">
            <?php if (isset($address)) {
                foreach ($address as $line) { ?>
                    <p><?= $line ?></p>
                <?php }
            } ?>
        </div>
        <div class="contact__content">
            <?php if ($email) { ?>
                <p>E: <a href="mailto:<?= $email ?>"><?= $email ?></a></p>
            <?php } ?>
            <?php if ($telephone) { ?>
                <p>T: <a href="tel:<?= $telephone ?>"><?= $telephone ?></a></p>
            <?php } ?>
            <?php if ($url) { ?>
                <p>W: <a href="<?= $url ?>" target="_blank" rel="noopener"><?= $url ?></a></p>
            <?php } ?>
            <?php if (isset($_GET['custLink']) && $AllowOutfitBuilder) { ?>
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal<?= get_the_id(); ?>">
                    Email Stockist
                </button>
            <?php } ?>
        </div>
    </div>

    
    <?php if (isset($_GET['custLink']) && $AllowOutfitBuilder) { ?>
    <!-- Modal -->
    <div class="modal fade" id="modal<?= get_the_id(); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Email Stockist</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="/stockists">
                        <input type="hidden" id="custLink" name="custLink" value="<?= $_GET['custLink']; ?>">
                        <label>Your Name:</label>
                        <input type="text" id="custName" name="custName">
                        <label>Your Email:</label>
                        <input type="text" id="custEmail" name="custEmail">
                        <label>Your Message:</label>
                        <input type="textarea" id="custMessage" name="custMessage">
                        <input type="hidden" id="stockistEmail" name="stockistEmail" value="<?= $email; ?>">
                        <input type="hidden" id="stockistName" name="stockistName" value="<?= $title; ?>">
                        <input type="submit" id="emailStockist" name="emailStockist" value="Send Email" class="view-stockists"><i class="fal fa-arrow-right view-stockists-arrow"></i>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
</article>
