<?php

if (isset($_GET['emailStockist'])) {

    $custLink = $_GET['custLink'] ?? "";
    $custName = $_GET['custName'] ?? "";
    $custEmail = $_GET['custEmail'] ?? "";
    $custMessage = $_GET['custMessage'] ?? "";
    
    $stockistEmail = $_GET['stockistEmail'] ?? "";
    $stockistName = $_GET['stockistName'] ?? "";

    $to = $stockistEmail;
    $subject = 'House of Edgar - Outfit Builder';
    $body = 'Dear '.$stockistName.',<br><br> A customer has visited the House of Edgar website and then contacted us to ask about a nearest stockist. We have therefore given them your details as their nearest stockist to provide them with the following outfit, all of which can be sourced from the House of Edgar.<br><br><a href="'.$custLink.'">Link to Outfit</a><br><br>Customer Name: ' . $custName . '<br>Customer Email: ' . $custEmail . '<br>Customer Message: ' . $custMessage . '<br> If you would like to be removed as a House of Edgar stockist and stop receiving enquiries of this nature, then please contact <a href="mailto:sales@houseofedgar.com">sales@houseofedgar.com</a>' ;
    $headers = array('Content-Type: text/html; charset=UTF-8');
    
    $emailSent = wp_mail( $to, $subject, $body, $headers );

    $to2 = 'jonathan@blue2.co.uk, jonathangmcleish@gmail.com';
    $subject2 = 'House of Edgar - Outfit Builder';
    $body2 = 'A stockist email has been sent! This is the email that has been sent: <br><br><br> Dear '.$stockistName.',<br><br> A customer has visited the House of Edgar website and then contacted us to ask about a nearest stockist. We have therefore given them your details as their nearest stockist to provide them with the following outfit, all of which can be sourced from the House of Edgar.<br><br><a href="'.$custLink.'">Link to Outfit</a><br><br>Customer Name: ' . $custName . '<br>Customer Email: ' . $custEmail . '<br>Customer Message: ' . $custMessage . '<br> If you would like to be removed as a House of Edgar stockist and stop receiving enquiries of this nature, then please contact <a href="mailto:sales@houseofedgar.com">sales@houseofedgar.com</a>' ;
    $headers2 = array('Content-Type: text/html; charset=UTF-8');
    
    $emailSent2 = wp_mail( $to2, $subject2, $body2, $headers2 );

    $to3 = $custEmail;
    $subject3 = 'House of Edgar - Outfit Builder Confirmation';
    $body3 = 'Thanks for your enquiry, an email has been sent to the stockist that you have selected, they should be in touch with you shortly!' ;
    $headers3 = array('Content-Type: text/html; charset=UTF-8');
    
    $emailSent3 = wp_mail( $to3, $subject3, $body3, $headers3 );
    
    if ($emailSent) {
        header("Location: http://$_SERVER[HTTP_HOST]/stockists/?sent=t");
    } else {
        header("Location: http://$_SERVER[HTTP_HOST]/stockists/?sent=f");
    }
}

if (isset($_GET['sent'])) {
    $emailIsSent = $_GET['sent'];
?>
    <div class="modal fade" id="modalSuccess" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Email Stockist</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?php
                    if ($emailIsSent) {
                    echo "<p>Your message has been sent!</p>";
                    } else {
                    echo "<p>Your message has not been sent.</p>";
                    }
                    ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

<?php
}
?>


<div class="stockist-archive padding-wrap">
    <div class="row">
        <div class="col-lg-4">
            <div class="d-md-flex">
                <h1>Stockists</h1>
            </div>
            <p><?= get_field(get_post_type() . '_description', 'option') ?></p>
            <input type="text" placeholder="Search by city / area" id="map-search" autocomplete="off">
            <div class="scroll-container clearfix" id="scroller">
                <?php if (have_posts()) {
                    while (have_posts()) {
                        the_post();
                        get_template_part('templates/distributor-stockist/content');
                    }
                } else {
                    get_template_part('templates/content', 'none');
                } ?>
            </div>
        </div>
        <div class="col-lg-8 map-section">
            <div class="google-map" id="google-map">
                <?php while (have_posts()) {
                    the_post();


                    if ($location = get_field('location')) {
                        if ($location !== false) {
                            $address = explode(', ', $location['address']);
                        }
                        $email = get_field('email_address');
                        $telephone = get_field('telephone_number');
                        $url = get_field('website_url');
                        $AllowOutfitBuilder = get_field('allow_outfit_builder_emails') ?? false;

                        ?>
                        <div class="marker"
                             data-lat="<?= $location['lat']; ?>"
                             data-lng="<?= $location['lng']; ?>"
                             data-index="stockist-<?= get_the_id(); ?>">
                            <article id="stockist-<?= get_the_id(); ?> stockist-content">
                                <strong><?php
                                    $title = strtolower(get_the_title());
                                    echo ucwords($title);
                                    ?>
                                </strong>
                                <div class="contact">
                                    <div class="contact__address">
                                        <?php if (isset($address)) {
                                            foreach ($address as $line) { ?>
                                                <p><?= $line ?></p>
                                            <?php }
                                        } ?>
                                    </div>
                                    <div class="contact__content">
                                        <?php if ($email) { ?>
                                            <p>E: <a href="mailto:<?= $email ?>"><?= $email ?></a></p>
                                        <?php } ?>
                                        <?php if ($telephone) { ?>
                                            <p>T: <a href="tel:<?= $telephone ?>"><?= $telephone ?></a></p>
                                        <?php } ?>
                                        <?php if ($url) { ?>
                                            <p>W: <a href="<?= $url ?>" target="_blank" rel="noopener"><?= $url ?></a>
                                            </p>
                                        <?php } ?>
                                        <?php if (isset($_GET['custLink']) && $AllowOutfitBuilder) { ?>
                                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal<?= get_the_id(); ?>">
                                                Email Stockist
                                            </button>
                                        <?php } ?>
                                    </div>
                                </div>
                            </article>
                        </div>
                        <?php
                    }
                } ?>
            </div>
        </div>

    </div>
</div>
