<?php

namespace Blue2\Scruffy\Controllers;


class WooCommerceController
{
    public function __construct()
    {
        add_action('init', [$this, 'initialiseWooCommerce']);

        add_action('wp_ajax_customVariableAddToCart', [$this, 'customVariableAddToCart']);
        add_action('wp_ajax_nopriv_customVariableAddToCart', [$this, 'customVariableAddToCart']);

    }

    public static function addToCartText()
    {
        return __('Order A Fabric Swatch', 'woocommerce');
    }

    public static function setupCollectionFromProduct()
    {
        global $wp_query;
        $category = get_the_terms(get_the_ID(), 'product_cat');
        $new_query = new \WP_Query();
        $new_query->parse_query([
            "product_cat" => $category[0]->slug,
            'wc_query' => 'product_query',
            'order' => 'ASC',
            'orderby' => 'title',
            'nopaging' => true,
        ]);
        do_action("woocommerce_product_query", $new_query, 'product_query', true);
        $new_query->get_queried_object();
        $new_query->get_posts();
        $wp_query = $new_query;
    }

    /**
     * @param $filter
     * @return array
     */
    public static function getFabricTypeCollections($filter)
    {
        if (isset($_GET) || !empty($_GET)) {
            $_GET['types'] = [$filter];
            $uniqueCollectionIds = self::getFilteredCollections();
        } else {
            $args[] = [
                'relation' => 'OR',
                [
                    'taxonomy' => 'fabric-type',
                    'field' => 'slug',
                    'terms' => $filter,
                ],
            ];
            $products = new \WP_Query([
                'post_type' => 'product',
                'post_status' => 'publish',
                'nopaging' => true,
                'fields' => 'ids',
                'tax_query' => $args,
            ]);

            $uniqueCollectionIds = self::getUniqueCollections($products);
        }
        return $uniqueCollectionIds;
    }

    public static function getFilteredCollections()
    {
        $taxArgs = self::getTaxQueryFromFilter();

        $products = new \WP_Query([
            'post_type' => 'product',
            'post_status' => 'publish',
            'nopaging' => true,
            'fields' => 'ids',
            'tax_query' => $taxArgs,
        ]);

        if ($products->post_count > 0) {
            $uniqueCollectionIds = self::getUniqueCollections($products);
            return $uniqueCollectionIds;
        } else return false;
    }

    public static function getTaxQueryFromFilter()
    {
        $allowedFilters = [
            'colour' => 'colour',
            'style' => 'fabric-style',
            'usage' => 'usage',
            'types' => 'fabric-type',
            'comp' => 'composition',
        ];

        $taxArgs = ['relation' => 'AND'];
        foreach ($_GET as $parameterKey => $parameterValue) {
            if (isset($allowedFilters[$parameterKey])) {
                $currentTerms = [];
                foreach ($parameterValue as $filterValue) {
                    $currentTerms[] = sanitize_text_field($filterValue);
                }

                $taxArgs[] = [
                    'taxonomy' => $allowedFilters[$parameterKey],
                    'field' => 'slug',
                    'terms' => $currentTerms,
                ];
            }
        }

        return $taxArgs;
    }

    /**
     * @param $products \WP_Query
     * @return array
     */
    private static function getUniqueCollections($products)
    {
        $parentIds = $products->posts;
        $parentIds = array_unique($parentIds);

        $collectionIds = [];
        foreach ($parentIds as $parentId) {
            $productCats = wp_get_post_terms($parentId, 'product_cat', ["fields" => "ids"]);
            if ($productCats) {
                $collectionIds = array_merge($collectionIds, $productCats);
            }
        }
        return $collectionIds = array_unique($collectionIds);
    }

    public static function outputCollections($collections)
    {
        global $wp_query;
        foreach ($collections as $collection) {
            $banner_id = get_woocommerce_term_meta($collection->term_id, 'thumbnail_id', true);
            $image = wp_get_attachment_image($banner_id, 'full ');
            $link = get_category_link($collection->term_id);
            if (is_tax('fabric-type')) {
                $tax = $wp_query->get_queried_object();
                $link .= '?types%5B%5D=' . $tax->slug;
            }
            ?>
            <article class="product d-flex flex-column">
                <a href="<?= $link ?>">
                    <?= $image != '' ? $image : wc_placeholder_img() ?>
                    <h3><?= $collection->name; ?></h3>
                </a>
                <a href="<?= $link ?>"
                   class="btn btn--no-fill btn__fullwidth">View Collection</a>
                <div class="overlay">
                    <a href="<?= $link ?>">
                        <h3><?= $collection->name; ?></h3>
                    </a>
                    <p><?= wp_trim_words($collection->description, 35, '...') ?></p>
                    <a href="<?= $link ?>" class="btn btn-primary mt-auto">View
                        Collection</a>
                </div>
            </article>
        <?php }
    }

    public static function variationAddToCart()
    {
        global $product; ?>
        <div class="woocommerce-variation-add-to-cart variations_button">
            <button type="submit"
                    class="button product_type_variable add_to_cart_button">Order A Fabric Swatch
            </button>
            <input type="hidden" name="add-to-cart" value="<?php echo absint($product->get_id()); ?>"/>
            <input type="hidden" name="product_id" value="<?php echo absint($product->get_id()); ?>"/>
            <input type="hidden" name="variation_id" class="variation_id" value="0"/>
        </div> <?php
    }


    function cartCountFragments($fragments)
    {
        $fragments['div.header-cart-count'] = '<div class="header-cart-count">' . WC()->cart->get_cart_contents_count() . '</div>';
        return $fragments;
    }

    function customVariableAddToCart()
    {
        global $woocommerce;
        $productId = $_POST['productId'];
        $variationId = $_POST['variationId'];

        $found = false;

        if (sizeof(WC()->cart->get_cart()) > 0) {
            foreach (WC()->cart->get_cart() as $cartItemKey => $values) {
                $product = $values['data'];
                if ($product->id == $product)
                    $found = true;
            }
            if (!$found)
                WC()->cart->add_to_cart($variationId);
        } else {
            WC()->cart->add_to_cart($variationId);
        }

    }

    public function initialiseWooCommerce()
    {
        $this->renameCategory();
        // Remove actions
        remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
        remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
        remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
        // Add actions
        add_action('woocommerce_product_after_variable_attributes', [$this, 'addColourToVariation'], 10, 3);
        add_action('woocommerce_save_product_variation', [$this, 'saveVariationColour'], 10, 2);
        add_action('woocommerce_created_customer', [$this, 'processCreatedCustomer']);
        add_action('woocommerce_add_to_cart', [$this, 'limitCartTotal'], 10, 6);

        add_filter('woocommerce_add_to_cart_fragments', [$this, 'updateCartFragment'], 10, 1);
        add_filter('woocommerce_product_add_to_cart_text', [$this, 'addToCartText']);
        add_filter('woocommerce_loop_add_to_cart_link', [$this, 'changeAddToCartLink'], 10, 2);
        
        add_action('wp_login', [$this, 'loginRedirect']);
        add_action('woocommerce_registration_redirect', [$this, 'loginRedirect']);
        add_action('pre_get_posts', [$this, 'productArchiveFilter']);
    }

    private function renameCategory()
    {
        global $wp_taxonomies;

        $cat = $wp_taxonomies['product_cat'];
        $cat->label = 'Collections';
        $cat->labels->singular_name = 'Collection';
        $cat->labels->name = $cat->label;
        $cat->labels->menu_name = $cat->label;
        $cat->labels->search_items = __('Search collections');
        $cat->labels->all_items = __('All collections');
        $cat->labels->parent_item = __('Parent collection');
        $cat->labels->parent_item_colon = __('Parent collection:');
        $cat->labels->edit_item = __('Edit collection');
        $cat->labels->update_item = __('Update collection');
        $cat->labels->add_new_item = __('Add new collection');
        $cat->labels->new_item_name = __('New collection name');
        $cat->labels->not_found = __('No collections found');
    }

    public function loginRedirect()
    {
        if (isset($_POST['referrer'])) {
            $product = get_permalink($_POST['referrer']);
            wp_redirect($product);
            exit;
        } else {
            wp_redirect('/my-account');
            exit;
        }
    }

    public function updateCartFragment($fragments)
    {
        $fragments['span.header-cart-count'] = '<span class="header-cart-count">(' . WC()->cart->get_cart_contents_count() . ')</span>';

        return $fragments;
    }

    /**
     * Action: woocommerce_created_customer
     */
    function processCreatedCustomer($customer_id)
    {
        if (isset($_POST['trade-account-number']) && $_POST['trade-account-number'] != '') {
            update_user_meta($customer_id, 'trade_account_number', sanitize_text_field($_POST['trade-account-number']));
            wp_mail(
                ['marketing@macnaughton-group.com', 'aileen@macnaughton-group.com'],
                'New trade user',
                '<p>A new customer has registered and provided a trade account number. Please confirm trade status and approve customer. </p><br>
                User email: ' . sanitize_text_field($_POST['email']) . '<p>You can edit them <a href="' . home_url() . '/wp/wp-admin/users.php">here</a>.</p>',
                ['Content-Type: text/html; charset=UTF-8']
            );
        }

        if (isset($_POST['trade-register']) && $_POST['trade-register'] == 'Yes') {
            wp_mail(
                ['sales@houseofedgar.com', 'ishbel@macnaughton-group.com'],
                'Trade user register request',
                '<p>A new customer has registered and requested a trade account application. Email:  ' . sanitize_text_field($_POST['email']) . '</p>',
                ['Content-Type: text/html; charset=UTF-8']
            );
            $fileId = get_field('trade_account_application', 'options');
            $file = get_attached_file($fileId);
            wp_mail(
                sanitize_text_field($_POST['email']),
                'House of Edgar Trade Account Request',
                '<p> Thank you for registering on the House of Edgar website. As you are registered you can now order samples of our fabrics. 
                    If you would like to become a trade customer please complete the attached application form and return to sales@houseofedgar.com at your earliest convenience. </p>',
                ['Content-Type: text/html; charset=UTF-8'],
                [$file]
            );
        }

        wp_send_new_user_notifications($customer_id, 'admin');
    }

    public function limitCartTotal($cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data)
    {
        global $woocommerce;
        $items = $woocommerce->cart->get_cart();

        $maxItems = 6;

        if (count($items) > $maxItems) {
            $woocommerce->cart->remove_cart_item($cart_item_key);
            throw new \Exception(sprintf('<a href="%s" class="button wc-forward">%s</a> %s', wc_get_cart_url(), __('View cart', 'woocommerce'), sprintf(__('You cannot add more than %s items to your cart.', 'woocommerce'), $maxItems)));
        }
    }

    /**
     * @param $query \WP_Query
     * @return mixed
     */
    public function productArchiveFilter($query)
    {
        if (is_admin() || !$query->is_main_query()) return $query;

        if (is_product_category() ) {
            $query->set('nopaging', true);
            $query->set('orderby', 'title');
            $query->set('order', 'ASC');

            if (isset($_GET) && !empty($_GET)) {
                $taxQuery = self::getTaxQueryFromFilter();
                $query->set('tax_query', $taxQuery);
            }
        }

        return $query;
    }

    function changeAddToCartLink($html, $product)
    {
        if (!is_user_logged_in()) {
            $button_text = __("Order A Fabric Swatch", "woocommerce");
            $html = '<a href="' . get_permalink(wc_get_page_id('myaccount')) . '?action=register&ref=' . get_the_id() . '" class="button alt add_to_cart_button">' . $button_text . '</a>';
        }
        return $html;
    }
}
