<?php
if (is_archive()) {
    $postId = $wp_query->posts[0]->ID;
    $useDarkLogo = get_field('dark_logo', $postId);
} else {
    $useDarkLogo = get_field('dark_logo');
}
?>

<div class="mobile-search d-md-none" id="mobile-search">
    <a href="#toggle-mobile-search"><i class="far fa-times"></i></a>
    <?php get_search_form(); ?>
</div>
<nav class="header-nav">
    <div class="header-nav__menu col-md-5">
        <div class="header-nav__menu-outer">
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation navigation--inline-toolbar d-none d-xl-flex flex-row']);
            }
            ?>
        </div>
    </div>
    <div class="header-nav__brand d-none d-md-block col-md-2">
        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
            <?php if (get_field('company_logo_dark', 'options') && (is_account_page() || is_checkout() || is_cart() || is_search() || is_404()) || $useDarkLogo == 1) { ?>
                <img class="d-none d-md-block" src="<?php echo get_field('company_logo_dark', 'options')['url']; ?>"
                     alt="<?php bloginfo('name'); ?>"/>
                <img class="d-md-none" src="<?php echo get_field('company_logo', 'options')['url']; ?>"
                     alt="<?php bloginfo('name'); ?>"/>
            <?php } else { ?>
                <img src="<?php echo get_field('company_logo', 'options')['url']; ?>" alt="<?php bloginfo('name'); ?>"/>
            <?php } ?>
        </a>
    </div>
    <div class="header-nav__menu col-6 col-md-4">
        <div class="header-nav__menu-outer">
            <a class="mobile-basket-link" href="<?= esc_url(home_url('/cart')); ?>">Basket <span
                        class="header-cart-count">(<?php echo WC()->cart->get_cart_contents_count(); ?>)</span></a>
            <ul class="navigation navigation--inline-toolbar d-none d-md-flex col-11 flex-row">
                <li class="searchform--header"><?php get_search_form(); ?></li>
                <li><a href="<?= esc_url(home_url('/cart')); ?>">Basket <span
                                class="header-cart-count">(<?php echo WC()->cart->get_cart_contents_count(); ?>)</span></a>
                </li>
                <li>
                    <?php
                    if (is_user_logged_in()) { ?>
                        <a class="header-account" href="/my-account/">My Account</a>
                        <!--<a class="header-account" href="/my-account/customer-logout/">Logout /</a> -->
                    <?php } else { ?>
                        <a class="header-account" href="/my-account/">Trade Login</a>
                    <?php } ?>
                </li>
                <li class="header-nav__translate"><a href="#"><span>EN </span><i class="gt_sectra--icon">v</i></a>
                    <div id="google_translate_element--desktop">
                        <div id="google_translate_element"></div>
                        <script type="text/javascript">
                            function googleTranslateElementInit() {
                                new google.translate.TranslateElement({
                                    pageLanguage: 'en',
                                    layout: google.translate.TranslateElement.InlineLayout.HORIZONTAL
                                }, 'google_translate_element');
                            }
                        </script>
                        <script type="text/javascript"
                                src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
                    </div>
                </li>
            </ul>
            <button class="navbar-toggler" type="button" data-target="#navbarSupportedContent"
                    aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <!-- <span class="navbar-toggler-icon"></span> -->
                <i class="fa far fa-bars"></i>
                <i class="fa far fa-times"></i>
            </button>
            <div class="header-nav__menu-container collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navigation navigation--inline-toolbar d-flex flex-row d-md-none justify-content-between">
                    <li><a href="#toggle-mobile-search">Search</a></li>
                    <li>
                        <?php
                        if (is_user_logged_in()) { ?>
                            <a class="header-account" href="/my-account/">My Account</a>
                            <!--<a class="header-account" href="/my-account/customer-logout/">Logout /</a> -->
                        <?php } else { ?>
                            <a class="header-account" href="/my-account/">Trade Login</a>
                        <?php } ?>
                    </li>
                    <li class="header-nav__translate"><a href="#">EN</a>
                        <div id="google_translate_element--mobile"></div>
                    </li>
                </ul>
                <?php
                if (has_nav_menu('main_menu')) {
                    wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation d-xl-none']);
                }
                if (has_nav_menu('push_menu')) {
                    wp_nav_menu(['theme_location' => 'push_menu', 'menu_class' => 'navigation']);
                }
                ?>

                <ul class="contact">
                    <?php if (get_field('contact_phone_number', 'option')) { ?>
                        <li><a href="tel:<?php the_field('contact_phone_number', 'option'); ?>"><i
                                        class="far fa-phone"></i> <?php the_field('contact_phone_number', 'option'); ?>
                            </a></li>
                    <?php } ?>
                    <?php if (get_field('contact_email_address', 'option')) { ?>
                        <li><a href="mailto:<?php the_field('contact_email_address', 'option'); ?>"><i
                                        class="far fa-envelope-open"></i> <?php the_field('contact_email_address', 'option'); ?>
                            </a></li>
                    <?php } ?>
                </ul>

                <nav class="social-media col-md">
                    <?php if (have_rows('social_media_channels', 'option')) { ?>
                        <p>
                            <?php
                            while (have_rows('social_media_channels', 'option')) {
                                the_row();
                                ?>
                                <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i
                                            class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a>
                                <?php
                            }
                            ?>
                        </p>
                    <?php } ?>
                </nav>
                <nav class="navigation navigation--footer col-md pl-0">
                    <?php
                    if (has_nav_menu('footer_menu')) {
                        wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => '']);
                    }
                    ?>
                </nav>


            </div>
        </div>
    </div>
</nav>
