<?php
$postCount = get_sub_field('number_of_stories');
$recent_posts = \Blue2\Scruffy\Controllers\PostController::getRecentPosts($postCount);
global $post;
?>

<div class="wrap-large">
    <section class="grid_section grid_section--front-page latest_news-grid">
        <div class="grid__content d-md-flex flex-wrap">
            <?php if (get_sub_field('section_intro')) { ?>
                <div class="col-12 text-center">
                    <?= get_sub_field('featured-news-panelsection_intro') ?>
                </div>
            <?php }
            ?>
            <div class="grid_row grid_row--sm-hscroll">
                <?php
                foreach ($recent_posts as $key => $post) {
                    setup_postdata($post);
                    $postThumb = get_the_post_thumbnail_url(null, 'full'); ?>
                    <div class="post-item col" <?= Blue2\Scruffy\Site::AOS_CLASSES[$key % 2];?> data-aos-anchor-placement="top-bottom" data-aos-duration="1000">
                        <a href="<?= get_the_permalink(); ?>">
                            <div style="background-image: url(<?= $postThumb; ?>);">
                                <div class="aspect--square"></div>
                            </div>
                            <p class="post-title"><?= get_the_title(); ?></p>
                            <span class="post-date"><?= get_the_date('jS F Y'); ?></span>
                        </a>
                    </div>
                <?php } ?>
            </div>
            <?php wp_reset_postdata(); ?>
        </div>
    </section>
</div>
