<?php

use Blue2\Scruffy\Controllers\BuildAnOutfitController;
if (have_rows('page_blocks')) {
    while (have_rows('page_blocks')) {
        the_row();
        $backgroundImage = get_sub_field('background_image');
        $backgroundImage = wp_get_attachment_image_url($backgroundImage, 'banner');

        $title = get_sub_field('title');
        $content = get_sub_field('content');
        $link = get_sub_field('link');
        $tartanColour = strtolower(get_sub_field('tartan_colour')) . '-tartan';

        $featuredImage = get_sub_field('featured_image');
        $featuredImage = wp_get_attachment_image_url($featuredImage, 'full');

        if (empty($_GET['step'])) {
            $currentStep = 'kilts';
        } else {
            $currentStep = $_GET['step'];
        }
        $stepClass = ' step--' . $currentStep;
        ?>
        <section class="offset-section container offset-section__build-outfit"
                 style="background-image:url('<?= $backgroundImage; ?>')">
            <div class="offset-feature wrap-large" style="background-image:url('<?= $featuredImage; ?>')">
                <div class="featured-image d-md-none">
                    <img src="<?= $featuredImage; ?>" alt=""/>
                </div>
                <div class="content-wrap <?= $tartanColour; ?>">
                    <span class="supertitle">Our Products</span>
                    <h1><?= $title; ?></h1>
                    <p><?= $content; ?></p>
                    <?php if ($link) { ?>
                        <a class="btn btn-primary" href="<?= $link['url']; ?>"
                           target="<?= $link['target']; ?>"><?= $link['title'] ?></a>
                    <?php } ?>
                </div>
            </div>
        </section>
        <section class="step-navigation wrap-large<?= $stepClass; ?>">
            <ul>
                <li><a href="?step=kilts">1.Kilt</a></li>
                <li><a href="?step=kilt-jackets">2.Jacket</a></li>
                <li><a href="?step=ties">3.Tie</a></li>
                <li><a href="?step=flashes">4.Flashes</a></li>
                <li><a href="?step=kilt-hoses">5.Kilt hoses</a></li>
                <li><a href="?step=plaid">6.Plaid</a></li>
            </ul>
        </section>
        <section class="product-list wrap-large outfit-builder">
            <div class="product-builder--wrapper">
                <div class="row product-builder-row" data-currentstep="<?= $currentStep; ?>">
                    <div class="col-2">
                        <a href="?step=kilts" class="product-element">
                            <?php $kiltProducts = $_SESSION['products']['kilts']; ?>
                            <img src="<?= $kiltProducts['productMainImage'] ?>" />
                            <?php if (isset($kiltProducts['productThumb'])) { ?>
                                <img class="thumbnail" src="<?= $kiltProducts['productThumb'] ?>" />
                            <?php } ?>
                        </a>
                    </div>
                    <div class="col-2">
                        <a href="?step=kilt-jackets" class="product-element">
                            <?= isset($_SESSION['products']['kilt-jackets']['variation']) && $_SESSION['products']['kilt-jackets']['variation'] != '' ? $product = wc_get_product($_SESSION['products']['kilt-jackets']['variation'])->get_image() : ''; ?>
                        </a>
                    </div>
                    <div class="col-2">
                        <a href="?step=ties" class="product-element">
                            <?php $tieProducts = $_SESSION['products']['ties']; ?>
                            <img src="<?= $tieProducts['productMainImage'] ?>" />
                            <?php if (isset($tieProducts['productThumb'])) { ?>
                                <img class="thumbnail" src="<?= $tieProducts['productThumb'] ?>" />
                            <?php } ?>
                        </a>
                    </div>
                    <div class="col-2">
                        <a href="?step=flashes" class="product-element">
                            <?php $flashesProducts = $_SESSION['products']['flashes']; ?>
                            <img src="<?= $flashesProducts['productMainImage'] ?>" />
                            <?php if (isset($flashesProducts['productThumb'])) { ?>
                                <img class="thumbnail" src="<?= $flashesProducts['productThumb'] ?>" />
                            <?php } ?>
                        </a>
                    </div>
                    <div class="col-2">
                        <a href="?step=kilt-hoses" class="product-element">
                            <?= isset($_SESSION['products']['kilt-hoses']['variation']) && $_SESSION['products']['kilt-hoses']['variation'] != '' ? $product = wc_get_product($_SESSION['products']['kilt-hoses']['variation'])->get_image() : ''; ?>
                        </a>
                    </div>
                    <div class="col-2">
                        <a href="?step=plaid" class="product-element">
                            <?= isset($_SESSION['products']['plaid']['variation']) && $_SESSION['products']['plaid']['variation'] != '' ? $product = wc_get_product($_SESSION['products']['plaid']['variation'])->get_image() : ''; ?>
                        </a>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php
                $steps = BuildAnOutfitController::getCorrectStep();

                if (empty($_GET['step'])) {
                    $stepComplete = false;
                } else {
                    if ($_GET['step'] == 'complete') {
                        $stepComplete = true;
                    } else {
                        $stepComplete = false;
                    }
                }

                if (!$stepComplete) { ?>
                    <div class="col-md-12">
                        <a class="btn btn-primary" href="?step=<?= $steps['next-step']; ?>">Next step</a>
                    </div>
                <?php }
                BuildAnOutfitController::getCorrectProductsForStep($steps['current-step']);
                if (empty($_GET['step'])) {
                    $stepComplete = false;
                } else {
                    if ($_GET['step'] == 'complete') {
                        $stepComplete = true;
                    } else {
                        $stepComplete = false;
                    }
                }
                if (!$stepComplete) { ?>
                    <div class="col-md-12">
                        <a class="btn btn-primary" href="?step=<?= $steps['next-step']; ?>">Next step</a>
                    </div>
                <?php }
                if ($stepComplete) { ?>
                    <div class="col-md-6">
                        <div class="row">
                            <?php BuildAnOutfitController::outputCorrectBuiltProducts(); ?>
                        </div>
                    </div>
                    <div class="col-md-6 stockist-element">
                        <div class="stockist-box">
                            <h2>Share with our stockists</h2>
                            <div class="link-box">
                                <input type="text" id="product-link" class="link"
                                       value="<?= get_home_url(); ?><?= BuildAnOutfitController::buildOutfitLink(); ?>">
                                <button class="copy-link">Copy Link</button>
                            </div>
                            <p>Copy your outfit link and share with one of our stockists via email to get your House of Edgar outfit. If you need help with the stockist finder or you can’t find a stockist near you, please contact us and our team will be happy to help.</p>
                            <form action="/stockists">
                                <input type="hidden" id="custLink" name="custLink" value="<?= get_home_url(); ?><?= BuildAnOutfitController::buildOutfitLink(); ?>">
                                <input type="submit" value="View all Stockists" class="view-stockists"><i class="fal fa-arrow-right view-stockists-arrow"></i>
                            </form>
                        </div>
                    </div>
                <?php } else {
                    ?>
                <?php } ?>
            </div>
        </section>
    <?php }
}
