(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["vendors~outfit-builder~product"],{

/***/ "./node_modules/egalink-toasty.js/dist/toasty.js":
/*!*******************************************************!*\
  !*** ./node_modules/egalink-toasty.js/dist/toasty.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

/*! Toasty.js - v1.5.0 - 2018-05-04
* https://jakim.me/Toasty.js/
* Copyright (c) 2015-2018 Jakim Hernández; Licensed MIT */
;

(function () {
  'use strict';
  /**
   * All available default CSS transitions for plug-in:
   *
   * @var array
   */

  var _transitions = ["fade", "slideLeftFade", "slideLeftRightFade", "slideRightFade", "slideRightLeftFade", "slideUpFade", "slideUpDownFade", "slideDownFade", "slideDownUpFade", "pinItUp", "pinItDown"];
  /**
   * Default configuration for plug-in:
   *
   * @var object
   */

  var _defaults = {
    // STRING: main class name used to styling each toast message with CSS:
    // .... IMPORTANT NOTE:
    // .... if you change this, the configuration consider that you´re
    // .... re-stylized the plug-in and default toast styles, including CSS3 transitions are lost.
    classname: "toast",
    // STRING: name of the CSS transition that will be used to show and hide all toast by default:
    transition: "fade",
    // BOOLEAN: specifies the way in which the toasts will be inserted in the HTML code:
    // .... Set to BOOLEAN TRUE and the toast messages will be inserted before those already generated toasts.
    // .... Set to BOOLEAN FALSE otherwise.
    insertBefore: true,
    // INTEGER: duration that the toast will be displayed in milliseconds:
    // .... Default value is set to 4000 (4 seconds). 
    // .... If it set to 0, the duration for each toast is calculated by text-message length.
    duration: 4000,
    // BOOLEAN: enable or disable toast sounds:
    // .... Set to BOOLEAN TRUE  - to enable toast sounds.
    // .... Set to BOOLEAN FALSE - otherwise.
    // NOTE: this is not supported by mobile devices.
    enableSounds: false,
    // BOOLEAN: enable or disable auto hiding on toast messages:
    // .... Set to BOOLEAN TRUE  - to enable auto hiding.
    // .... Set to BOOLEAN FALSE - disable auto hiding. Instead the user must click on toast message to close it.
    autoClose: true,
    // BOOLEAN: enable or disable the progressbar:
    // .... Set to BOOLEAN TRUE  - enable the progressbar only if the autoClose option value is set to BOOLEAN TRUE.
    // .... Set to BOOLEAN FALSE - disable the progressbar. 
    progressBar: false,
    // IMPORTANT: mobile browsers does not support this feature!
    // Yep, support custom sounds for each toast message when are shown if the
    // enableSounds option value is set to BOOLEAN TRUE:
    // NOTE: the paths must point from the project's root folder.
    sounds: {
      // path to sound for informational message:
      info: "./dist/sounds/info/1.mp3",
      // path to sound for successfull message:
      success: "./dist/sounds/success/1.mp3",
      // path to sound for warn message:
      warning: "./dist/sounds/warning/1.mp3",
      // path to sound for error message:
      error: "./dist/sounds/error/1.mp3"
    },
    // callback:
    // onShow function will be fired when a toast message appears.
    onShow: function (type) {},
    // callback:
    // onHide function will be fired when a toast message disappears.
    onHide: function (type) {},
    // the placement where prepend the toast container:
    prependTo: document.body.childNodes[0]
  };
  /**
   * Map to create each necessary CSS classess:
   *
   * @var object
   */

  var _mappings = {
    container: "{:class-name}-container",
    mainwrapp: "{:class-name}-wrapper",
    toasts: {
      info: "{:class-name}--info",
      success: "{:class-name}--success",
      warning: "{:class-name}--warning",
      error: "{:class-name}--error"
    },
    animate: {
      init: "{:transition}-init",
      show: "{:transition}-show",
      hide: "{:transition}-hide"
    },
    progressbar: "{:class-name}-progressbar",
    playerclass: "{:class-name}-soundplayer"
  };
  /**
   * A time offset to define the plug-in behavior:
   *
   * @var object
   */

  var _timeOffset = 100;
  /**
   * A native JS extend() function
   *
   * Returns a new object instead, preserving all of the original objects
   * and their properties. Supported back to IE6.
   *
   * All credits to author.
   * https://gomakethings.com/vanilla-javascript-version-of-jquery-extend/
   *
   * @return object
   */

  function extend() {
    var extended = {};
    var deep = false;
    var i = 0;
    var length = arguments.length; // check if a deep merge

    if (Object.prototype.toString.call(arguments[0]) === '[object Boolean]') {
      deep = arguments[0];
      i++;
    } // merge the object into the extended object


    var merge = function (obj) {
      for (var prop in obj) if (Object.prototype.hasOwnProperty.call(obj, prop) === true) {
        // if deep merge and property is an object, merge properties
        if (deep && Object.prototype.toString.call(obj[prop]) === '[object Object]') extended[prop] = extend(true, extended[prop], obj[prop]);else extended[prop] = obj[prop];
      }
    }; // loop through each object and conduct a merge


    for (i; i < length; i++) {
      var obj = arguments[i];
      merge(obj);
    }

    return extended;
  }
  /**
   * Simple creation of an Element Node with the specified 'name'.
   *
   * @return HTML Element
   */


  function node(name) {
    return document.createElement(name || 'div');
  }
  /**
   * Returns the parent Element or Node from any other HTML Element.
   *
   * @return HTML Element
   */


  function parentElement(el) {
    return el.parentElement || el.parentNode;
  }
  /**
   * Regexp to find a className on a string.
   *
   * @return RegExp Obj
   */


  function classReg(className) {
    return new RegExp('(^|\\s+)' + className + '(\\s+|$)');
  }
  /**
   * Returns a Boolean value, indicating whether an element has
   * the specified class name.
   * 
   * Usage:
   *
   * var exists = containsClass(element, 'className');
   * 
   * @return bool
   */


  function containsClass(el, className) {
    var fn;

    if (document.documentElement.classList) {
      fn = function (el, className) {
        return el.classList.contains(className);
      };
    } else {
      fn = function (el, className) {
        if (!el || !el.className) return false;
        return el.className.match(classReg(className));
      };
    }

    return fn(el, className);
  }
  /**
   * Adds one or more class names to an element.
   * If the specified class already exist, the class will not be added.
   *
   * Usage:
   *
   * addClass(el, 'class1', 'class2', 'class3', ...);
   *
   * @return HTML Element|bool false
   */


  function addClass(el) {
    var fn;
    var classNames = arguments;
    if (classNames.length <= 1 || typeof el != 'object') return false;
    if (document.documentElement.classList) fn = function (el, classNames) {
      for (var i = 1; i < classNames.length; i++) if (typeof classNames[i] == 'string') {
        el.classList.add(classNames[i]);
      }

      return el;
    };else fn = function (el, classNames) {
      for (var i = 1; i < classNames.length; i++) if (!containsClass(el, classNames[i]) && typeof classNames[i] == 'string') {
        el.className += (el.className ? ' ' : '') + classNames[i];
      }

      return el;
    };
    return fn(el, classNames);
  }
  /**
   * Removes one or more class names from an element.
   * Note: Removing a class that does not exist, does NOT throw an error.
   *
   * Usage:
   *
   * removeClass(el, 'class1', 'class2', 'class3', ...);
   *
   * @return HTML Element|bool false
   */


  function removeClass(el) {
    var fn;
    var classNames = arguments;
    if (classNames.length <= 1 || typeof el != 'object') return false;
    if (document.documentElement.classList) fn = function (el, classNames) {
      for (var i = 1; i < classNames.length; i++) if (typeof classNames[i] == 'string') {
        el.classList.remove(classNames[i]);
      }

      return el;
    };else fn = function (el, classNames) {
      for (var i = 1; i < classNames.length; i++) if (containsClass(el, classNames[i]) && typeof classNames[i] == 'string') {
        el.className = el.className.replace(classReg(classNames[i]), '$2');
      }

      return el;
    };
    return fn(el, classNames);
  }
  /**
   * Toggles between a class name for an element.
   * 
   * Usage:
   *
   * var result = toggleClass(el, 'className');
   *
   * @return bool
   */


  function toggleClass(el, className) {
    var fn;
    if (document.documentElement.classList) fn = function (el, className) {
      return el.classList.toggle(className);
    };else fn = function (el, className) {
      var exists = containsClass(el, className);
      var caller = exists === true ? removeClass : addClass;
      caller(el, className);
      return !exists;
    };
    return fn(el, className);
  }
  /**
   * Add Event
   *
   * Attaches an event handler to the document.
   *
   * http://www.thecssninja.com/javascript/handleevent
   *
   * @param  {element}  element
   * @param  {event}    event
   * @param  {Function} fn
   * @param  {boolean}  bubbling
   * @return el
   */


  function addEvent(el, evt, fn, bubble) {
    if ('addEventListener' in el) {
      // BBOS6 doesn't support handleEvent, catch and polyfill:
      try {
        el.addEventListener(evt, fn, bubble);
      } catch (e) {
        if (typeof fn === 'object' && fn.handleEvent) {
          el.addEventListener(evt, function (e) {
            // bind fn as this and set first arg as event object:
            fn.handleEvent.call(fn, e);
          }, bubble);
        } else {
          throw e;
        }
      }
    } else if ('attachEvent' in el) {
      // check if the callback is an object and contains handleEvent:
      if (typeof fn === 'object' && fn.handleEvent) {
        el.attachEvent('on' + evt, function () {
          // bind fn as this:
          fn.handleEvent.call(fn);
        });
      } else {
        el.attachEvent('on' + evt, fn);
      }
    }

    return el;
  }
  /**
   * Remove Event
   *
   * Removes an event handler that has been attached with the 'addEvent' method.
   *
   * http://www.thecssninja.com/javascript/handleevent
   *
   * @param  {element}  element
   * @param  {event}    event
   * @param  {Function} fn
   * @param  {boolean}  bubbling
   * @return el
   */


  function removeEvent(el, evt, fn, bubble) {
    if ('removeEventListener' in el) {
      try {
        el.removeEventListener(evt, fn, bubble);
      } catch (e) {
        if (typeof fn === 'object' && fn.handleEvent) {
          el.removeEventListener(evt, function (e) {
            fn.handleEvent.call(fn, e);
          }, bubble);
        } else {
          throw e;
        }
      }
    } else if ('detachEvent' in el) {
      if (typeof fn === 'object' && fn.handleEvent) {
        el.detachEvent('on' + evt, function () {
          fn.handleEvent.call(fn);
        });
      } else {
        el.detachEvent('on' + evt, fn);
      }
    }

    return el;
  }
  /**
   * Detect the property name of supported transition event.
   * 
   * Function from David Walsh:
   * http://davidwalsh.name/css-animation-callback
   *
   * @return string|undefined (if transitions not supported by client)
   */


  function whichTransitionEvent() {
    var t,
        el = node('transitionElement');
    var transitions = {
      WebkitTransition: 'webkitTransitionEnd',
      MozTransition: 'transitionend',
      OTransition: 'oTransitionEnd otransitionend',
      transition: 'transitionend'
    };

    for (t in transitions) if (el.style[t] !== undefined) {
      return transitions[t];
    }
  }
  /**
   * Calculates the auto close duration to be set in
   * each toast message:
   * 
   * @return number
   */


  function getAutoCloseDuration(message, duration, settings) {
    duration = duration || settings.duration;
    if (duration == 0) duration = message.length * (_timeOffset / 2);
    return Math.floor(duration);
  }
  /**
   * Replace each object values with a map of key => values:
   *
   * @return object
   */


  function walker(obj, map) {
    for (var o in obj) if (obj.hasOwnProperty(o) === true) {
      // ini loop:
      switch (typeof obj[o]) {
        case 'object':
          walker(obj[o], map);
          break;

        case 'string':
          for (var m in map) if (map.hasOwnProperty(m) === true) {
            obj[o] = obj[o].replace(m, map[m]);
          }

          break;
      } // end loop.

    }

    return obj;
  }
  /**
   * Generate an HTML audio instance for each type of
   * toast message:
   *
   * @return void
   */


  var playSound = function (type, container, sounds, playerclass) {
    var sound = sounds[type],
        audio = addClass(node('audio'), playerclass);
    addEvent(audio, 'ended', function () {
      var parent = parentElement(this);
      this.remove(); // also, remove the main container if it empty:

      if (parent.childNodes.length < 1) parentElement(parent).remove();
    });
    audio.setAttribute('autoplay', 'autoplay');
    audio.innerHTML = '<source src="' + sound + '" type="audio/mpeg"/>' + '<embed hidden="true" autoplay="false" loop="false" src="' + sound + '" />';
    parentElement(container).appendChild(audio);
  };
  /**
   * Show the toast message with an CSS3 transition
   * if transition event is supported:
   *
   * @return void
   */


  var showToast = function (type, el, container, animate, duration, insertBefore, callback) {
    var timer = 0;

    var delay = function (callback, ms) {
      clearTimeout(timer);
      timer = setTimeout(callback, ms);
    };

    var onShowToast = function (e) {
      removeEvent(e.target, e.type, onShowToast, false);
      if (typeof callback == 'function') callback(type);
    };

    var show = function () {
      var transitionEvent = whichTransitionEvent();

      if (transitionEvent !== undefined) {
        // initialize the CSS transition event:
        addEvent(el, transitionEvent, onShowToast, false);
      } else {
        // navigator does not support transition events:
        if (typeof callback == 'function') callback(type);
      }

      addClass(el, animate.show);
    }; // insert in the DOM and show toast:


    var beforeNode = container.childNodes;
    beforeNode = beforeNode[insertBefore === true ? 0 : beforeNode.length];
    container.insertBefore(el, beforeNode);
    delay(show, _timeOffset);
  };
  /**
   * Hide the toast message with an CSS3 transition
   * if transition event is supported:
   *
   * @return void
   */


  var hideToast = function (type, el, duration, animate, callback) {
    var timer = 0;

    var delay = function (callback, ms) {
      clearTimeout(timer);
      timer = setTimeout(callback, ms);
    };

    var onHideToast = function (e) {
      removeEvent(e.target, e.type, onHideToast, false);
      remove();
      if (typeof callback == 'function') callback(type);
    };

    var remove = function () {
      var container = parentElement(el); // the wrapper.

      el.remove();
      var num = container.childNodes.length;

      if (num < 1) {
        parentElement(container).remove();
      }
    };

    var hide = function () {
      var transitionEvent = whichTransitionEvent();

      if (transitionEvent !== undefined) {
        // initialize the CSS transition event:
        addEvent(el, transitionEvent, onHideToast, false);
      } else {
        // navigator does not support transition events:
        remove();
        if (typeof callback == 'function') callback(type);
      }

      addClass(el, animate.hide);
    };

    delay(hide, _timeOffset * 10 + duration);
  };
  /**
   * Hide the toast message with an CSS3 transition when
   * the user clicks on the message:
   *
   * @return void
   */


  var hideToastOnClick = function (type, el, animate, callback, class2close) {
    var hideOnClick = function (e) {
      e.stopPropagation();
      removeClass(el, class2close);
      hideToast(type, el, 0, animate, callback);
    };

    addClass(el, class2close);
    addEvent(el, 'click', hideOnClick);
  };
  /**
   * The progressbar:
   *
   * @return void
   */


  var showProgressBar = function (type, el, duration, transition) {
    var timer = 0;

    var delay = function (callback, ms) {
      clearTimeout(timer);
      timer = setTimeout(callback, ms);
    };

    var progressbar = function () {
      var progressBar = addClass(node('div'), transition.progressbar, transition.progressbar + '--' + type);
      el.appendChild(progressBar);
      var iterat = 0,
          offset = 0;
      var interval = setInterval(function () {
        iterat++;
        offset = Math.round(1000 * iterat / duration);

        if (offset > 100) {
          clearInterval(interval);
        } else {
          progressBar.style.width = offset + '%';
        }
      }, 10);
    };

    delay(progressbar, _timeOffset * 10);
  };
  /**
   * Register a new transition only:
   *
   * @return string
   */


  var registerTransition = function (self, name) {
    if (typeof name === "string") {
      self.classmap[name] = extend(true, _mappings, {});
      self.classmap[name] = walker(self.classmap[name], {
        '{:class-name}': self.settings.classname,
        '{:transition}': name
      });
    }

    return name;
  };
  /*!
   * The exposed public object:
   */


  var Toasty = function (options) {
    this.settings = {};
    this.classmap = {};
    this.configure(typeof options === 'object' ? options : {}); // add classmap for default transitions:

    if (typeof _transitions === 'object') for (var key in _transitions) if (_transitions.hasOwnProperty(key) === true) {
      registerTransition(this, _transitions[key]);
    }
  };

  Toasty.prototype.configure = function (options) {
    this.settings = extend(true, _defaults, this.settings, options);
    return this;
  };

  Toasty.prototype.transition = function (name) {
    this.settings.transition = registerTransition(this, name);
    return this;
  };

  Toasty.prototype.toast = function (type, message, duration) {
    var classes = this.classmap;
    var options = this.settings; // check if the transition name provided in options
    // exists in classes, if not register it:

    if (classes.hasOwnProperty(options.transition) === false) registerTransition(this, options.transition); // use the transition name provided in options:

    var transition = classes[options.transition]; // check if the toast container exists:

    var container = null;
    if (typeof options.transition === 'string') container = document.querySelector('.' + transition.container + '--' + options.transition);else container = document.querySelector('.' + transition.container);
    var containerExists = !!container;

    if (containerExists) {
      // create the toast container if not exists:
      container = container.querySelector('.' + transition.mainwrapp); // use the wrapper instead of main container.
    } else {
      container = addClass(node('div'), transition.container, transition.container + '--' + options.transition); // create a alert wrapper instance:

      var wrapp = addClass(node('div'), transition.mainwrapp); // append the alert wrapper and now, this is the main container:

      container.appendChild(container = wrapp);
    } // create a new toast instance


    var newToast = addClass(node('div'), options.classname, transition.toasts[type], transition.animate.init);
    newToast.innerHTML = message; // insert the toast container into the HTML:

    if (!containerExists) document.body.insertBefore(parentElement(container), options.prependTo); // OPTIONAL STEP (must be first):
    // INI: enable or disable toast sounds.
    // --------------------------------------------------------------------

    if (options.enableSounds == true) playSound(type, container, options.sounds, transition.playerclass); // --------------------------------------------------------------------
    // END: enable or disable toast sounds.
    // STEP 1:
    // INI: showing the toas message
    // --------------------------------------------------------------------

    showToast(type, newToast, container, transition.animate, duration, options.insertBefore, options.onShow); // --------------------------------------------------------------------
    // END: showing the toas message
    // STEP 2:
    // INI: prepare the toast to hide it.
    // --------------------------------------------------------------------

    if (options.autoClose == true) // hide the toast message automatically:
      hideToast(type, newToast, duration, transition.animate, options.onHide);else // hide the toast message on click it with an CSS3 transition:
      hideToastOnClick(type, newToast, transition.animate, options.onHide, 'close-on-click'); // --------------------------------------------------------------------
    // END: prepare the toast to hide it.
    // OPTIONAL STEP (must be last):
    // INI: Enable or disable the progressbar.
    // --------------------------------------------------------------------

    if (options.progressBar == true && options.autoClose == true) showProgressBar(type, newToast, duration, transition); // --------------------------------------------------------------------
    // END: Enable or disable the progressbar.

    return this;
  };

  Toasty.prototype.info = function (message, duration) {
    duration = getAutoCloseDuration(message, duration, this.settings);
    this.toast("info", message, duration);
  };

  Toasty.prototype.success = function (message, duration) {
    duration = getAutoCloseDuration(message, duration, this.settings);
    this.toast("success", message, duration);
  };

  Toasty.prototype.warning = function (message, duration) {
    duration = getAutoCloseDuration(message, duration, this.settings);
    this.toast("warning", message, duration);
  };

  Toasty.prototype.error = function (message, duration) {
    duration = getAutoCloseDuration(message, duration, this.settings);
    this.toast("error", message, duration);
  }; // FALLBACK:
  // Create Element.remove() function if not exist:


  if ('remove' in Element.prototype) {// the browser supports .remove() function...
  } else {
    Element.prototype.remove = function () {
      if (this.parentNode) this.parentNode.removeChild(this);
    };
  }

  window.Toasty = Toasty;
})(window, document);

/***/ }),

/***/ "./node_modules/egalink-toasty.js/dist/toasty.min.css":
/*!************************************************************!*\
  !*** ./node_modules/egalink-toasty.js/dist/toasty.min.css ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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